/*
 * Important - Countries have to be parsed in order of appearance in the JSON file as is processed as a stream and not in memory
 * Credit: Rodrigo Pombo for putting this together: https://github.com/pomber/covid19
 * 
 * v12 - adding catch for getting prior day which is the end of the prior month. Cleaned up bugs related to parsing days when data needs to be retrieved between 2 months.
 * v11 - moving some variables to make local in functions.   Added checkNullsInt() function as discovered that some data can come through as NULL
 * v10 - stable version.
 */

//#define BLYNK_DEBUG            // for blynk debugging
//#define BLYNK_PRINT Serial    // Comment this out to disable prints and save space
//#include <ESP8266WiFi.h>  //dont use this if using Blynk.
#include <BlynkSimpleEsp8266.h>  //if using an ESP8266 use this and comment below line out.
//#include <BlynkSimpleEsp32.h>  //If using an ESP32, change to this>> <BlynkSimpleEsp32.h> and comment the above line out.
#include <ArduinoJson.h>
#include <Nextion.h>
#include <string.h>
#include <WiFiClientSecure.h>
#include <TimeLib.h> //https://github.com/PaulStoffregen/Time   
#include <WidgetRTC.h>


//############################################################################################################################
//F O R    D E B U G G I N G   U S I N G    N E X T I O N    E D I T O R
//Select one or the other option.  Dont forget to set debug = false once you put it in production.

//PRODUCTION:  Use this when using the physical MCU + Nextion TFT LCD Hardware or MCU + Serial Window.  
#define nextion Serial1  
boolean debug = true;   //Be sure to set to false when done debugging!!

//TESTING:  Use this to debug using the Nextion Editor HMI over Serial with your MCU connected to your PC via USB
//#define nextion Serial  
//boolean debug = false;  //debugging in serial window.  DONT SET THIS TO TRUE WHEN DEBUGGING IN NEXTION HMI USING SERIAL
//############################################################################################################################

boolean firsttime = true;
const long refreshCovidInt = 60*60*1000; //1 hour  >>  Minutes * Seconds * MS
//const long checkRTCInt = 2*60*60*1000;     //10 mins  >>  Hour * Minutes * Seconds * MS
unsigned long prevCovidRefMillis = 0;
//unsigned long prevRTCMillis = 0;

char covidDate[10][15];   //[rows] x [characters]
int covidDay[10];         //[rows]
int covidConfirmed[10];   //[rows]
int covidDeaths[10];      //[rows] 
int covidRecovered[10];   //[rows]  


//############################################################################################################################
//B L Y N K    C O N N E C T I O N
char ssid[32]     = "SSID";
char password[32] = "PWD";
char auth[] = "BLYNK_AUTH_KEY"; //Can get by creating Blynk account and downloading App on phone.  Easy and free to start.


Nextion myNextion(nextion, 115200); //create a Nextion object named myNextion using the nextion serial port @ 115200bps
WiFiClientSecure secureWiFiClient;  // Instance of secure client to enable HTTPS request
//BearSSL::WiFiClientSecure secureWiFiClient; 
WidgetRTC rtc;  //Blynk RTC widget

  
//#####################################################################################################################################################

void setup()
{
  Serial.begin(115200);  //Standard Serial comms
  Serial1.begin(115200); //Comms to Nextion
  
  Serial.flush();  // added for debugging
  Serial1.flush(); // added for comms to Nextion

  // send the initialization commands for Page 0 - this is the page "startup"
  if (!myNextion.init())
  {
    if (debug) {Serial.println(F("Problem!  Nextion TFT did not initialize!"));}
  }

  myNextion.setComponentText("tStatusText", "Connecting to WiFi...");
  
  Blynk.begin(auth, ssid, password);
  if (debug) {Serial.println(F("Connecting to Blynk"));}
    while (Blynk.connect() == false) {
     //Wait until connected
     if (debug) {Serial.println(".");}
  }
  rtc.begin();
  myNextion.setComponentText("tStatusText", "Connected.");
  delay(1000); //for RTC to sync

  if (debug) {Serial.println(F("Connected.  Processing loop..."));}
} 
 
// END SETUP

void loop()
{
  unsigned long currentMillis = millis();
  //** must keep this loop running without delays so Blynk can run correctly.  
  //Use timer-based triggers to run code based on delays - see refresh weather data below.
  Blynk.run();

  if ((firsttime) && (currentMillis > 10000))  //after a break, get data on startup.
  {
    if (year() != 1970)  //dont process if the RTC isn't updated
    {
      myNextion.setComponentText("tStatusText", "Getting first time COVID-19 Data.");
      getCovidData();
      firsttime = false;
    }
  }

  if (currentMillis - prevCovidRefMillis > refreshCovidInt) 
  {
    prevCovidRefMillis = currentMillis; // save the last time we checked
    if (year() != 1970)  //dont process if the RTC isn't updated
    {
      myNextion.setComponentText("tStatusText", "Getting COVID-19 Data.");
      getCovidData();
    }
  }

  /*
  if (currentMillis - prevRTCMillis > checkRTCInt)
  {
    prevRTCMillis = currentMillis; // save the last time we checked
    
    if (year() == 1970)
    {
     if (debug) {Serial.println(F("Delay in getting RTC Date..."));} 
     myNextion.setComponentText("tStatusText", "Delay in acquiring RTC Date...");
    }
    else
    {
     if (debug) {Serial.println(F("RTC ok but this should not be happening!"));} 
    }
  }
  */

  
  
}  //END Loop


//#####################################################################################################################################################
bool getCovidData()
{
  const char host[] = "pomber.github.io"; 
  char conStr[200];
  char status[32] = {0};
  char endOfHeaders[] = "\r\n\r\n";
  char findCanada[] = "\"Canada\": [";
  char CanadaName[] = "Canada";
  char findChina[] = "\"China\": [";
  char ChinaName[] = "China";
  char findItaly[] = "\"Italy\": [";
  char ItalyName[] = "Italy";  
  char findUSA[] = "\"US\": [";
  char USAName[] = "US";
  char findIndia[] = "\"India\": [";
  char IndiaName[] = "India";
  char findUK[] = "\"United Kingdom\": [";
  char UKName[] = "UK";
  char scrollerTxt[300];

  char comma[] = ",";
  char endOfArray[] = "]";
  int i=0, maxVal=0;
  int rptY, rptM, rptD;
  char updatetime[50];
  char hr[4];
  unsigned long maxV = 1000L;
  
  
  //strcpy(conStr, "GET https://pomber.github.io/covid19/timeseries.json HTTP/1.1\r\nHost: pomber.github.io\r\nConnection: close\r\n\r\n");
  strcpy(conStr, "GET https://pomber.github.io/covid19/timeseries.json");
  strcat(conStr, " HTTP/1.1\r\nUser-Agent: ESP8266/0.1\r\nAccept: */*\r\nHost: ");
  strcat(conStr, host);
  strcat(conStr, "\r\nConnection: close\r\n\r\n");  
 
  yield();

  if (debug) {Serial.println(F("Connect to host.."));}
  if (debug) {Serial.println(conStr);}

  secureWiFiClient.setInsecure();
  if (!secureWiFiClient.connect(host, 443)) {
      if (debug) {Serial.println(F("Connection failed.."));}
      return false;
  }
  yield();
  //SEND THE REQUEST
  if (debug) {Serial.println(conStr);}
  if (debug) {Serial.println(F("Send the connection string.."));}
  secureWiFiClient.print(conStr);
  yield();


  //use this to dump response.  
  /*
  Serial.print("Response Header: ");
  while(secureWiFiClient.available()){
    char stat[1];
    secureWiFiClient.readBytesUntil('\r', stat, sizeof(stat));
      //secureWiFiClient.readBytes(stat, sizeof(stat));
    Serial.print(stat);
  }
  Serial.println();
  */

  // Check HTTP status
  if (debug) {Serial.println(F("Check HTTP return status.."));}
 
  secureWiFiClient.readBytesUntil('\r', status, sizeof(status));
  yield();
    if (strcmp(status, "HTTP/1.1 200 OK") != 0) {
    if (debug) {Serial.print(F("Current Data: Unexpected response. Status received = "));}
    if (debug) {Serial.println(status);}
    return false;
  }
  yield();
  
  // Skip HTTP headers

  if (!secureWiFiClient.find(endOfHeaders)) {
    if (debug) {Serial.println(F("Invalid response"));}
    return false;
  }

  if (secureWiFiClient.find(findCanada) == 0)
  {
    if (debug) {Serial.println(F("Could not find:  \"Canada\" : [ "));}
    return false;
  }
  yield();

  do  //loop through all records for selected Country and find the last 7 days.
  {
    StaticJsonDocument<1024> jbDoc;  //processing on the fly - hence why this is in the loop.  
    DeserializationError error = deserializeJson(jbDoc, secureWiFiClient);
    if (error)
    {
      if (debug) {Serial.print(F("Deserialization of jb failed with code "));}
      if (debug) {Serial.println(error.c_str());}
      break;
    }    
    //date looks like this: 2020-2-23 
    //startDay = (String(startDate).substring(6,8)).toInt();
    const char* dateReported = jbDoc["date"].as<char*>();
    sscanf(dateReported, "%d-%d-%d", &rptY, &rptM, &rptD);  //splits the date into YYYY MM DD
    
    //if the current day is less than 7 days, then we have to look for data from this, and the prior month.
    //Remember the data being reported from the prior day, so there will never be data for the current day >> day().
    if (day() < 7)
    {
      //look at the prior month and last days based on whats left of 7 days
      if ( (rptM == month()-1) && (rptD >= numDaysInMonth(year(), month()-1) - (7 - day())) )
      {
       //strcpy(covidLocation[i], "Canada");
       strlcpy(covidDate[i], jbDoc["date"] | "N/A", sizeof(covidDate));
       covidDay[i] = rptD;
       covidConfirmed[i] = checkNullsInt(jbDoc["confirmed"].as<int>());
       covidDeaths[i] = checkNullsInt(jbDoc["deaths"].as<int>());
       covidRecovered[i] = checkNullsInt(jbDoc["recovered"].as<int>());
       i++;       
      }      
      //now get the remaining days in the existing month.  
      if ( (rptM == month()) && (rptD <= day() - 1) )  
      {
       strlcpy(covidDate[i], jbDoc["date"] | "N/A", sizeof(covidDate));
       covidDay[i] = rptD;
       covidConfirmed[i] = checkNullsInt(jbDoc["confirmed"].as<int>());
       covidDeaths[i] = checkNullsInt(jbDoc["deaths"].as<int>());
       covidRecovered[i] = checkNullsInt(jbDoc["recovered"].as<int>());
       i++;
      }          
    }
    else  //fulling within the first 7 days of the month
    {
      if ((rptM == month()) &&(rptD >= day() - 7))
      {
       strlcpy(covidDate[i], jbDoc["date"] | "N/A", sizeof(covidDate));
       covidDay[i] = rptD;
       covidConfirmed[i] = checkNullsInt(jbDoc["confirmed"].as<int>());
       covidDeaths[i] = checkNullsInt(jbDoc["deaths"].as<int>());
       covidRecovered[i] = checkNullsInt(jbDoc["recovered"].as<int>());
       i++;
      }      
    }     
    yield();
    if (covidConfirmed[i-1] > maxV){maxV = covidConfirmed[i-1];}  //get max val to set bar graph height mapping
    //if (debug) {Serial.println(maxV);}
  } while (secureWiFiClient.findUntil(comma, endOfArray));  //get all data for country and stop at end of array.

  if (debug)
  {
    Serial.println("");
    for (int j; j<7; j++)
    {Serial.print(" Country: Canada");Serial.print(" Date: ");Serial.print(covidDate[j]);Serial.print(" Day: ");Serial.print(covidDay[j]);Serial.print(" Confirmed: ");Serial.print(covidConfirmed[j]);Serial.print(" Deaths: "); Serial.print(covidDeaths[j]);Serial.print(" Recovered: ");Serial.print(covidRecovered[j]);Serial.println("");}
  }
  //int opac = 127;
  //send the data over to the Nextion.
  for (int i=0; i<7; i++)
  {
       // WORKING!!! myNextion.sendCommandLong(getVarName("v", i, "1.val="),  map(jbDoc["confirmed"].as<int>(), 0, 1000, 1, 100));
       myNextion.setComponentText(getVarNameStr("d", i, "day"), String(covidDay[i])+ "" + strDaySuffix(covidDay[i]));   //day number
       
       myNextion.sendCommandLong(getVarName("v", i, "1.val="),  map(covidConfirmed[i], 0, maxV, 1, 100));                       //bar height 
       //myNextion.sendCommandInt(getVarName("v", i, "1.aph="), opac);                                                          //make non-transparent  
       myNextion.sendCommandLong(getVarName("d", i, "1.val="), covidConfirmed[i]);                                              //data value 
       myNextion.sendCommandInt(getVarName("d", i, "1.y="), getPos(covidConfirmed[i], maxV));                                   //data value pos 
       //myNextion.sendCommandInt(getVarName("d", i, "1.aph="), opac);                                                          //make non-transparent  
              
       myNextion.sendCommandLong(getVarName("v", i, "2.val="), map(covidDeaths[i], 0, maxV, 1, 100));                           //bar height 
       //myNextion.sendCommandInt(getVarName("v", i, "2.aph="), opac);                                                          //make non-transparent  
       myNextion.sendCommandLong(getVarName("d", i, "2.val="), covidDeaths[i]);                                                 //data value 
       myNextion.sendCommandInt(getVarName("d", i, "2.y="), getPos(covidDeaths[i], maxV));                                     //data value pos
       //myNextion.sendCommandInt(getVarName("d", i, "2.aph="), opac);                                                         //make non-transparent                                                          
              
       myNextion.sendCommandLong(getVarName("v", i, "3.val="), map(covidRecovered[i], 0, maxV, 1, 100));                        //bar height 
       //myNextion.sendCommandInt(getVarName("v", i, "3.aph="), opac);                                                          //make non-transparent  
       myNextion.sendCommandLong(getVarName("d", i, "3.val="), covidRecovered[i]);                                              //data value 
       myNextion.sendCommandInt(getVarName("d", i, "3.y="), getPos(covidRecovered[i], maxV));                                   //data value pos
       //myNextion.sendCommandInt(getVarName("d", i, "3.aph="), opac);                                                          //make non-transparent
       
       //memset(result, 0, sizeof(result));
       yield;
  }
  resetArray();  //done with arrays - reset them.

  myNextion.setComponentText("tStatusText", "Canada updated. Searching others...");

  yield();
  
  strlcpy(scrollerTxt, "Yesterday\\r\\r", sizeof(scrollerTxt));  //to start it off.
  if (debug) {Serial.print("ScrollerTxt starting Data: ");}  
  if (debug) {Serial.println(scrollerTxt);}   //send data for Countries that are scrolled.


  //order MUST match order in timeseries.json file being parsed.
  strlcat(scrollerTxt, processScrollerData(findChina, ChinaName), sizeof(scrollerTxt));
  strlcat(scrollerTxt, processScrollerData(findIndia, IndiaName), sizeof(scrollerTxt));
  strlcat(scrollerTxt, processScrollerData(findItaly, ItalyName), sizeof(scrollerTxt));
  strlcat(scrollerTxt, processScrollerData(findUK, UKName), sizeof(scrollerTxt));
  strlcat(scrollerTxt, processScrollerData(findUSA, USAName), sizeof(scrollerTxt));

  if (debug) {Serial.print("ScrollerTxt finishing Data: ");}  
  if (debug) {Serial.println(scrollerTxt);}   //send data for Countries that are scrolled.
  myNextion.setComponentText("scroller", scrollerTxt);

  strlcpy(updatetime, "Covid-19 Data Last Updated: ", sizeof(updatetime)); 
  sprintf(hr,"%d",get12Hr(hour()));
  strlcat(updatetime,  hr, sizeof(updatetime)); 
  strlcat(updatetime, ":", sizeof(updatetime));
  if (minute() < 10)
  {
   strlcat(updatetime, "0", sizeof(updatetime));  //add the leading '0'.. i.e. 14:04
  }
  char m2[4];
  sprintf(m2,"%d",minute());
  strlcat(updatetime, m2, sizeof(updatetime)); 
  strlcat(updatetime, isAM() ? "AM" : "PM", sizeof(updatetime));  //Now add on AM / PM for the current time

  myNextion.setComponentText("tStatusText", updatetime);
  
  secureWiFiClient.stop();  //done with connection

  return true;
}

//#####################################################################################################################################################
char *processScrollerData(char *CountrySearch, char *CountryName)
{
  int reprtY, reprtM, reprtD, priorDay, monthToGet;
  char comma[] = ",";
  char endOfArray[] = "]";
  char textInfo[100];
  if (debug) {Serial.println(CountrySearch);}
  if (secureWiFiClient.find(CountrySearch) == 0)
  {
    if (debug) {Serial.println("Could not find data for Country.");}
    myNextion.setComponentText("tStatusText", "Could not find data for Country");
    return "";  //returns blank
  }
  yield();

  //strlcpy(textInfo, "", sizeof(textInfo));
  
  do  //loop through all records for selected Country and find the last day and retrieve that data.
  {
    StaticJsonDocument<256> jbDoc;  //processing on the fly - hence why this is in the loop.  
    DeserializationError error = deserializeJson(jbDoc, secureWiFiClient);
    if (error)
    {
      if (debug) {Serial.print(F("Deserialization of jb failed with code "));}
      if (debug) {Serial.println(error.c_str());}
      myNextion.setComponentText("tStatusText", "Deserialization of jb failed with code.");
      return "";   //returns blank
    }  
    
    const char* dateReported = jbDoc["date"].as<char*>();  //date looks like this: 2020-2-23 
    sscanf(dateReported, "%d-%d-%d", &reprtY, &reprtM, &reprtD);
    //if (debug) {Serial.print("ReportM:"); Serial.print(reprtM); Serial.print(" ActualM:"); Serial.print(month());Serial.print(" ReportD:"); Serial.print(reprtD);Serial.print(" ActualDay:"); Serial.println(day());} 

    //need to account for the 1st of each month. Prior day is last day of last month.
    if (day() == 1)
    {
      if (month() == 1)
      {
        priorDay = 31;  //December
        monthToGet = 12;
      }
      else
      {
        priorDay = numDaysInMonth(year(), month()- 1);  //get the last day of the prior month
        monthToGet = month() - 1;
      }
    }
    else
    {
      priorDay = day() - 1;
      monthToGet = month();
    }
    
    //if ((reprtM == month()) && (reprtD == (day() - 1)))  //Only want the most recent day which is yesterday in the dataset
    if ((reprtM == monthToGet) && (reprtD == priorDay))  //Only want the most recent day which is yesterday in the dataset
    {
     //if (debug) {Serial.print(F(" Processing data.."));}
     yield();
     //THIS SAMPLE WORKS
     //myNextion.setComponentText("scroller", "Italy:\\rConfirmed:999\\rDeaths:111 Recovered:222");

     strlcpy(textInfo, CountryName, sizeof(textInfo));
     strlcat(textInfo, ":\\rConf:  ",sizeof(textInfo));
     char cval[12];
     sprintf(cval,"%d",checkNullsInt(jbDoc["confirmed"].as<int>())); // put the int into a string
     strlcat(textInfo, cval, sizeof(textInfo));
     memset(cval, 0, sizeof(cval));
     
     strlcat(textInfo, "\\rDeath: ", sizeof(textInfo));     
     sprintf(cval,"%d",checkNullsInt(jbDoc["deaths"].as<int>())); // put the int into a string
     strlcat(textInfo, cval, sizeof(textInfo));     
     memset(cval, 0, sizeof(cval));
     
     strlcat(textInfo, "\\rRecov: ", sizeof(textInfo));
     //sprintf(cval,"%d",jbDoc["recovered"].as<int>()); // put the int into a string
     //checkNullsInt(int val)
     sprintf(cval,"%d",checkNullsInt(jbDoc["recovered"].as<int>())); // put the int into a string
     strlcat(textInfo, cval, sizeof(textInfo));
     memset(cval, 0, sizeof(cval));
     strlcat(textInfo, "\\r\\r",sizeof(textInfo));  //for the next Country listing
    }      
    yield();   
  } while (secureWiFiClient.findUntil(comma, endOfArray));  //get all data for country and stop at end of array.
  
  //if (debug) {Serial.print("FunctionReturned:"); Serial.println(textInfo);}
  return textInfo;
  
  if (debug) {Serial.println(F(" Done processing this Country."));}
  // E N D    
  //**************************************************************************************  
}


//#####################################################################################################################################################
char *getVarName(char * part1, int index, char * part2)
{
  char varVal[12];
  char val[4];
       
  strlcpy(varVal, part1, sizeof(varVal));
  sprintf(val,"%d",index+1); // put the int into a string. Variable names in Nextion start at 1 for day 1.
  strlcat(varVal, val, sizeof(varVal));
  strlcat(varVal, part2, sizeof(varVal));
  //if (debug) {Serial.print("varName: "); Serial.println(varVal);}
  return varVal;
}

//#####################################################################################################################################################
//modified from above to return a string value
String getVarNameStr(char * part1, int index, char * part2)
{
  char varVal[12];
  char val[4];
       
  strlcpy(varVal, part1, sizeof(varVal));
  sprintf(val,"%d",index+1); // put the int into a string. Variable names in Nextion start at 1 for day 1.
  strlcat(varVal, val, sizeof(varVal));
  strlcat(varVal, part2, sizeof(varVal));
  //if (debug) {Serial.print("varName: "); Serial.println(varVal);}
  return String(varVal); ;
}

//#####################################################################################################################################################
int getPos(long longVal, long mV)
{
 //purpose is to return the a value for the y position of the data variables so they float above the graph bars.
 //Data Elemements positioning:  start y=0, h=85, bargraph start y=85 h=350. Value range is 0-100
 //435 is y value at bottom of the bar. Work up from there.  mV is the max value of the Confirmed dataset that sets overall.
 //mV is the max value of confirmed cases
 
 return 435 - map(longVal, 0, mV, 0, 350) - 87;
}


//#####################################################################################################################################################

uint8_t numDaysInMonth( uint16_t year, uint8_t month )
{
  if ( month == 2 ) 
    return ( (year % 400 == 0) || (year % 4 == 0 && year % 100 != 0) ) ? 29 : 28;
    
  else if ( month == 4 || month == 6 || month == 9 || month == 11 ) 
      return 30;
      
  return 31;
}
//#####################################################################################################################################################

void resetArray()
{
    //memset(scrollerTxt, 0, sizeof(scrollerTxt));    
    memset(covidDate, 0, sizeof(covidDate));    
    memset(covidDay, 0, sizeof(covidDay));    
    memset(covidConfirmed, 0, sizeof(covidConfirmed));    
    memset(covidDeaths, 0, sizeof(covidDeaths));    
    memset(covidRecovered, 0, sizeof(covidRecovered));    
}



//#####################################################################################################################################################
String strDaySuffix(int dy)
{
  //if (debug) {Serial.println("DayValueInt: "); Serial.println(dy);}
  switch (dy)
    {
      case 1:
      case 21:
      case 31:
      return "st";
      case 2:
      case 22:
      return "nd";
      case 3:
      case 23:
      return "rd";
      default:
      return "th";
    }
}

//#####################################################################################################################################################
int get12Hr(int h)
{
  int hr_24 = h;
   if ((hr_24 == 0) || (hr_24 == 12)) 
   {
    return 12;
   }
   else 
   {
    return hr_24%12;
   }
}
//#####################################################################################################################################################
const int checkNullsInt(int val)
{
  return val ? val : 0;  //reads as return value if not null, else return 0.
}

//#####################################################################################################################################################
//Called as checkNullsChar(current["observation_time"])
const char *checkNullsChar(char const* val)
{
  return val ? val : "";  //reads as return value if not null, else return "".
}
