/********************************************************************************

Developed by Dave @ www.Plastibots.com  

Credits Nextion Library:
https://github.com/bborncr/nextion

RMP monitoring:
Crenn from http://thebestcasescenario.com
http://www.themakersworkbench.com/content/tutorial/reading-pc-fan-rpm-arduino
//info in interrupts
https://www.arduino.cc/reference/en/language/functions/external-interrupts/attachinterrupt/


Nextion Library
https://github.com/bborncr/nextion/blob/master/examples/AllTogether/AllTogether.ino

*************************************************************************************/
//v20 - LED control: removal of physical push button switch and integration into using the Nextion tapping the LED area to turn lights on.
//v19 - integrating callbacks from the Nextion to perform actions.
//v18 - cleaning up and stabilizing
//v17 - Nextion 2.4" HMI LCD integration and makeover
//v16 - June 2020.  Updated with tweaks to text, placement etc.  Temp probes now on x and y axis.
//V16 - Moved the pwr supply temp sensor over to the Extruder MOSFET.  This provides more accurate
//temp monitoring and ensures the fan is on when the extruder is heating. 

#include <NextionSoftSer.h>
#include <SoftwareSerial.h>


#define fanSpdPin 6     // was5  //PWM out to control fan speed (blue wire on 4 pin fans) 
#define tmpLBotPin A2   //Power supply temp monitor pin
#define tmpPiPin A1     //Pi board temp monitor pin
#define LEDpin 5        // Pin D5 to control PWM to LEDs. Connected to 2N2904A to drive 12V to LEDs.
#define hallsensor 2    //The pin location of the fan PWM sensor (green wire on 4 pin fans)
#define beepPin 7       // buzzer pin
#define tempMin 20      // base temperature - only really for reference and calculations.  The fan will always have a minimum speed
#define tempMax 50      // the maximum temperature that will trigger fan to go to 100%
#define minFanSpeed 65  //range 0-255

int tmpLBot=0,tmpPi=0;
int lasttmpLBot=0,lasttmpPi=0;
volatile byte half_revolutions;
unsigned int rpm;
unsigned long timeold;
int lastRPM = 0;
int lastPct = 0, currPct = 0;
int level = 0, lastLevel = 0;       // LED light level selected
int LEDMode = 0, lastLEDMode = 0; //values 0=off, to 3 Highest
char levelTxt[15] = "-";
boolean fanBypass=0;
unsigned long previousMillis = 0;       
const long interval = 1000;      
char cmd1[20];
char cmd2[4];

//############################################################################################################################
// Debugging
boolean debug = false;   //Be sure to set to false when done!!
//############################################################################################################################

SoftwareSerial nextion(2, 8);// Nextion TX to pin 2(RX on Nano) and RX to pin 8 of Arduino
Nextion myNextion(nextion, 115200);  //create a Nextion object named myNextion using the nextion serial port @ 115200bps


void setup()
{ 
  Serial.begin(115200);  //Standard Serial comms
   
  pinMode(LEDpin, OUTPUT);
  pinMode(hallsensor, INPUT_PULLUP);  //for interrupt to work
  pinMode(fanSpdPin, OUTPUT);
  pinMode(tmpLBotPin, INPUT);
  pinMode(tmpPiPin, INPUT);

  analogWrite(fanSpdPin, minFanSpeed);  // spin the fan at a low speed by default
  
  
  // Init the Nextion
  if (!myNextion.init())
  {
    if (debug) {Serial.println(F("Problem!  Nextion TFT did not initialize!"));}
  }

  myNextion.sendCommand("tmrFan.en=1");

  //Fan RPM monitoring via interrupt
  //attachInterrupt(0, rpm_fan, RISING);  //for pin 2 - hall effect sensor on FAN
  attachInterrupt(digitalPinToInterrupt(hallsensor), rpm_fan, RISING);  //for pin 2 - hall effect sensor on FAN
  half_revolutions = 0;
  rpm = 0;
  timeold = 0;

  //Push Button Interrupt - No longer used 
  //using interrupt so all button presses are caught regardless of other timers etc.
  //attachInterrupt(1, monitorPushbutton, CHANGE);  //for LED light control switch monitoring.  Nano - D3

  setLEDs();//first time - set to LEDs high
  
}



void loop ()
{ 
   unsigned long currentMillis = millis();
   currPct = 0;

   processNextionMsg();

   //Get RPM readings
   if (half_revolutions >= 20) 
   { 
     //Update RPM every 20 counts, increase this for better RPM resolution,
     //decrease for faster update
     rpm = 30*1000/(millis() - timeold)*half_revolutions;
     timeold = millis();
     half_revolutions = 0;
     //Serial.println(rpm,DEC);
   }

   //Get Temperature Readings
   tmpLBot = readTemp(tmpLBotPin);     // get the temperature
   tmpPi = readTemp(tmpPiPin);     // get the temperature

   //Do screen updates here - this ocurrs once per interval - currently set as 1 second
   if (currentMillis - previousMillis >= interval) 
   {
     // save the last time you blinked the LED
     previousMillis = currentMillis;

     //Show Fan RPM value - only if it is different
     if (rpm != lastRPM)
     {
       myNextion.sendCommandInt("nFanRPM.val=", rpm); 
     }
     
     lastRPM = rpm;
     if (debug) {Serial.print("RPM: ");Serial.println(rpm);}
     
     //###################  Print the Einsy Temp Value Info
     if ((tmpLBot != lasttmpLBot) && (tmpLBot != NULL)) //only do it if changed (avoids flicker)
     {
       myNextion.sendCommandInt("n0.val=", tmpLBot);
       //if (debug) {Serial.print("PicIDToUse:");Serial.println(getTempRingPos(tmpLBot));}
       myNextion.sendCommandInt("p0.pic=", tmpToRingPos(tmpLBot)); 
       myNextion.sendCommand("ref p5");  //the deg C picture will go behind, so needs to be refreshed
       if (debug) {Serial.print("Temp: ");Serial.println(tmpLBot);}
     }
     //Set the Einsy temperature waveform - always want this updating
     sprintf(cmd2,"%d",tmpLBot);
     strcpy(cmd1, "add 13,0,");  //!!!!! Watch out. Whevenver you change your Nextion HMI, the ID of the Waveform may change.  This needs to be updated.
     strcat(cmd1, cmd2);
     if (debug) {Serial.print("CmdEinsy: ");Serial.println(cmd1);}
     myNextion.sendCommand(cmd1);      //send command to update the waveform
     
     memset(cmd1, 0, sizeof(cmd1));   //clears out cmd for use again below
     memset(cmd2, 0, sizeof(cmd2));   //clears out cmd for use again below
     //lasttmpLBot = tmpLBot;
      
     //###################  Set the second temperature Value
     if ((tmpPi != lasttmpPi) && (tmpPi != NULL))    //only do it if changed (avoids flicker)
     {
       myNextion.sendCommandInt("n1.val=", tmpPi);
       //Set the second temperature Ring Meter picture
       myNextion.sendCommandInt("p1.pic=", tmpToRingPos(tmpPi));
       myNextion.sendCommand("ref p4");  //the deg C picture will go behind, so needs to be refreshed  
       if (debug) {Serial.print("PicIDToUse2:");Serial.println(tmpToRingPos(tmpPi));}
       if (debug) {Serial.print("tmpPi: ");Serial.println(tmpPi);}
     }
     //Set the second temperature Waveform - always want this updating
     sprintf(cmd2,"%d",tmpPi);
     //Serial.print("Cmd: ");Serial.println(cmd2);
     strcpy(cmd1, "add 12,0,");  //!!!!! Watch out. Whevenver you change your Nextion HMI, the ID of the Waveform may change.  This needs to be updated.
     strcat(cmd1, cmd2);
     if (debug) {Serial.print("CmdOctoPi: ");Serial.println(cmd1);}
     //if (debug) {Serial.print("tmpPi: ");Serial.println(tmpPi);}
     myNextion.sendCommand(cmd1);       //send command to update the waveform
     
     memset(cmd1, 0, sizeof(cmd1));   //clears out cmd for use again below
     memset(cmd2, 0, sizeof(cmd2));   //clears out cmd for use again below
     //lasttmpPi = tmpPi;
     
     //###################  Manage the fan speed
     //if Nextion Temp area touched, will send fanBypass message to Nano.  Will trigger fan @ 100%

     if (fanBypass)  //fan set to 100% by user in Nextion HMI
     {
       analogWrite(fanSpdPin, 255);
       currPct = 100; 
       lasttmpLBot = 0;  //set it to some value so the below check can reset once bypass is turned off.
       if (debug) {Serial.print("FanBypasss IS ON ");}
     }
     else
     {
       //Temperature: Manage the Fan Speed based on temparature
       //map(temp, lowTemp, maxTemp,fanMinSpeed, FanMaxSpeed
       if (tmpLBot != lasttmpLBot)  //only want to send commands if temp has changed from last time.
       {
         if (tmpLBot > tempMax)
         {
           //temp is excessive and above range, keep fan on high until it comes down
           analogWrite(fanSpdPin, 255); 
           currPct = 100; 
           beep();   //send out a warning beep to alert user that attention may be required
         }
         //keep the baseline minimum speed on
         else if (tmpLBot < tempMin)
         {
           analogWrite(fanSpdPin, minFanSpeed);
           currPct = (minFanSpeed/255.0)*100; //value set for startup
           if (debug) {Serial.print("Fan%FromMinSpeed: ");Serial.println(currPct);}
         }
         else
         {
           //auto adjust fan based on temp ranges  - with this circuit the Noctual is not happy below 40.
           analogWrite(fanSpdPin, map(tmpLBot, tempMin, tempMax, minFanSpeed, 255));          
           currPct = (map((float)tmpLBot, (float)tempMin, (float)tempMax, (float)minFanSpeed, 255.0) / 255.0) * 100;
           if (debug) {Serial.print("Fan%Calc: ");Serial.println(currPct);}
         } 
       }
     }

     if (currPct != lastPct) 
     {
       myNextion.sendCommandInt("nFanPct.val=", currPct);
     }
     
     lastPct = currPct;
     lasttmpLBot = tmpLBot;
     lasttmpPi = tmpPi;
      
   } //end timer interval check
 
} 
// end loop
//##############################################################################################


void processNextionMsg()
{
  //listen to messages from the Nextion display
  //**** THE VALUES WILL CHANGE EACH TIME HMI IS UPDATED - PIC REMOVALS OR SHUFFLING!
  String message = listen2Nextion(); //check for message
  if (message != "") 
    { // if a message is received...
      if (debug) {Serial.print(F(">>>>>>>>>Nextion Msg: ")); Serial.println(message);
    }

    if (message == "Fb")  //Fan Bypass - turn fan on high
    {
       fanBypass = true;
       beep();
       if (debug) {Serial.println(F("Fan Bypass command sent"));}  
    }
    if (message == "Fn")  //left garage door clicked
    {
       fanBypass = false;
       beep();
       if (debug) {Serial.println(F("Fan Norm command sent"));}  
    }
    if (message == "LEDSw")  //Processing a change to weather location
    {
      if (debug) {Serial.println(F("LEDSwitch event triggered on Nextion"));} 
      beep();
      setLEDs();

    }
  }

  //interpreting messages
  //if (message == "65 0 2 0 ffff ffff ffff") { //if button "b0" is Released
  //  //do something
  //}
  //65: This message is a touch event
  //0: The page ID is 0
  //2: Component ID (the number of the first button in the Editor) -oddly the component IDs dont match IDs in my nextion
  //0: Type of event. A "0" means a Release event, A "1" is a Press event
  //FFFF FFFF FFFF: The end of message pattern
  //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  
}
//#####################################################################################################################################################
int tmpToRingPos(int tempVal)
{
  int x;
  //if (tempVal > 80) tempVal = 80;
  //if (tempVal < 10) tempVal = 10;
  //map(value, fromLow, fromHigh, toLow, toHigh)
  //x = map(tempVal, 10,80, 1,13); //will map temp values to picture ID values for the ring meter.
  x = map(constrain(tempVal, 10, 80), 10,80, 1,13); //will map temp values to picture ID values for the ring meter.
  return  x;
}

//##############################################################################################

int readTemp(int pin) {  // get the temperature and convert it to celsius
  int temp;
  temp = analogRead(pin);
  return temp * 0.48828125;
}
//##############################################################################################
void setLEDs()
{
  int pic=13;
  long colour=63488;
 
  //LEDmode, lastLEDMode
  switch (LEDMode) 
  {
    case 0:  //default is to start high
      pic = 13;
      colour = 63488;
      level = 0;
      strcpy(levelTxt, "t0.txt=\"H\"");  //Nextion needs to see this as t0.txt="H".
      break;
    case 3: //then to Medium
      pic = 6;
      colour = 65504;
      level = 55;
      strcpy(levelTxt, "t0.txt=\"M\"");
      break;
    case 2:  //then to low
      pic = 3;
      colour = 890;
      level = 105;
      strcpy(levelTxt, "t0.txt=\"L\"");
      break;
    case 1: //then to off
      pic = 1;
      colour = 51712;
      level = 255;
      strcpy(levelTxt, "t0.txt=\"Off\"");
      break;
    default: 
      pic = 1;
      level = 255;
      strcpy(levelTxt, "t0.txt=\"Off\"");
      break;  
   }
  LEDMode --; //reduce the value to change down
  if (LEDMode<0)LEDMode=3;
  
  myNextion.sendCommand(levelTxt); 
  //Change the ring meter graphic     
  myNextion.sendCommandInt("p2.pic=",pic); 
  //myNextion.sendCommandInt("t0.pco=",colour); 
  myNextion.sendCommandLong("t0.pco=",colour);
               
  //Turn on the LEDs
  //analogWrite(LEDpin, map(level, 0, 100, 255, 0));
  analogWrite(LEDpin, level);
  if (debug){Serial.print("  Level: ");Serial.println(level);}
  
  
}
//##############################################################################################


 
// #########################################################################
// Return a value in range -1 to +1 for a given phase angle in degrees
// #########################################################################
float sineWave(int phase) {
  return sin(phase * 0.0174532925);
}

 void rpm_fan()
 {
   half_revolutions++;
   //Each rotation, this interrupt function is run twice
 }

 void beep()
{
   tone(beepPin,2500, 100);  
   //delay(500);
   //tone(beepPin,3000, 300);  
   //delay(500);
}  


//#####################################################################################################################################################
//Brought this into code as it needed modification due to using Serial on NodeMCU to allow serial debug + nextion on the Serial RX line.
String listen2Nextion()  //returns generic
{
  char _bite;
  char _end = 0xff;//end of file x3
  String cmd;
  int countEnd = 0;

  while(Serial.available())
  {
    delay(10);
    if(Serial.available())
    {
      _bite = Serial.read();
      cmd += _bite;
      if(_bite == _end)
      {
        countEnd++;
      }//end if
      if(countEnd == 3)
      {
        break;
      }//end if
    }//end if
  }//end while

/* if(cmd != ""){
  for(int o  = 0 ; o < cmd.length(); o++){
    Serial.print(cmd[o], HEX);
  }
  Serial.println();
  }//*/

  String temp = "";
  switch (cmd[0]) {
  case 'e'://0x65   Same than default -.-
  countEnd = 0;//Revision for not include last space " "
  for(uint8_t i = 0; i<cmd.length(); i++){
    if(cmd[i] == _end){countEnd++;}//end if
    temp += String(cmd[i], HEX);//add hexadecimal value
    if(countEnd == 3){
    return temp;
    }//end if
    temp += " ";//For easy visualization
  }//end for
  break;
  case 'f'://0x66
  //Serial.print(String(cmd[1], HEX));
  return String(cmd[1], DEC);
  break;
  case 'g'://0x67
  cmd = String(cmd[2], DEC) + "," + String(cmd[4], DEC) +","+ String(cmd[5], DEC);
  return cmd;
  break;
  case 'h'://0x68
  cmd = String(cmd[2], DEC) + "," + String(cmd[4], DEC) +","+ String(cmd[5], DEC);
  cmd = "68 " + cmd;  
  return cmd;
  break;
  case 'p'://0x70
  cmd = cmd.substring(1, cmd.length()-3);
  cmd = "70 " + cmd;
  return cmd;
  break;
  default: 
  //  cmd += String(b, HEX);
  //if(ff == 3){break;}//end if
  //cmd += " ";//
  return cmd;//
  break;
  }//end switch 
  return "";
}//end listen
