// Developed by Plastibots.com   Credits for borrowed code snippets and ideas as follows:
//https://community.blynk.cc/t/troubleshooters-needed-esp8266-mailbox-notify/11529/6
//https://ezcontents.org/esp8266-battery-level-meter
//https://github.com/blynkkk/blynk-library/blob/master/examples/Widgets/RTC/RTC.ino

//Hardware References (may not have used this code):
//https://tasmota.github.io/docs/devices/TYWE3S/
//https://forum.arduino.cc/index.php?topic=614512.0
//https://www.letscontrolit.com/forum/viewtopic.php?t=6955
//https://tasmota.github.io/docs/TuyaMCU-Devices/
//https://forum.iobroker.net/topic/9886/tuya-jinvoo-unterputz-wandschalter/17  >> this was not needed >> To get into boot mode, touch RST and GPIO0 to GND for 2-3 seconds, release RST and keep GPIO0 for 2-3 more seconds.



//V5 - adding static IP address
//V4 - stable version using OTA
//v2 - added date/time and battery level


//#define BLYNK_PRINT Serial  
#include <ESP8266WiFi.h>
#include <BlynkSimpleEsp8266.h>
#include <WidgetRTC.h>
#include <SimpleTimer.h>

//BEGIN OTA
#include <ESP8266WiFi.h>        
#include <ESP8266mDNS.h>
#include <WiFiUdp.h>
#include <ArduinoOTA.h>
#include <ESP8266WebServer.h>
#include <ESP8266HTTPUpdateServer.h>  //Note see ESP8266HTTPUpdateServer-impl.h for updated HTML formatted firmware updater table visuals. 
const char* OTAhost = "ESPWinSnsr2"; // Note - use of hostname often doesn't work, so just find the IP address and use it. e.g.: "192.168.1.100/update" in web browser
ESP8266WebServer httpServer(80);
ESP8266HTTPUpdateServer httpUpdater;
//END OTA

//############################################################################################################################
//B L Y N K    C O N N E C T I O N
char ssid[32]     = "SSID";
char password[32] = "SSIDPWD";
char auth[] = "BLYNK AUTH";
//############################################################################################################################
//Static IP assignment.  Why? Because it speeds up connectivity. In some cases as fast as 2 seconds from boot.
//HINT getting the arduino_mac is easy.  Just add 0x to the front of each aplhaNum set.
// Mac address should be different for each device in your LAN

byte mac[6];                     // the MAC address of your ESP
byte arduino_mac[] = { 0xDE, 0xED, 0xBA, 0xFE, 0xFE, 0xED };
IPAddress arduino_ip (192, 168, 2, 40); //this is the IP you want for your ESP
IPAddress dns_ip     (8, 8, 8, 8);
IPAddress gateway_ip (192, 168, 2, 1);
IPAddress subnet_mask(255, 255, 255, 0);


//############################################################################################################################


//**** D E B U G  *****************
const boolean debug = true;
//*********************************

boolean notificationSent = false;
int tmrSleep;    
const long sleepDelayMs = 60 * 1000;       //delay before ESP goes to sleep - 2 mins

char message[150];
char result[6];
int nVoltageRaw;
float fVoltage; 
int i;// perc=100;


//BlynkTimer timer;
WidgetRTC rtc;
WidgetTerminal terminal(V0);
SimpleTimer timer;                     // the timer object

/* BLYNK_CONNECTED() 
{
  // Synchronize time on connection
  rtc.begin();
}
*/
// You can send commands from Terminal to your hardware. Just use
// the same Virtual Pin as your Terminal Widget  
//THIS IS NOT CURRENTLY BEING USED
BLYNK_WRITE(V0)
{
  // if you type "Marco" into Terminal Widget - it will respond: "Polo:"
  if (String("Marco") == param.asStr()) {
    terminal.println("You said: 'Marco'") ;
    terminal.println("I said: 'Polo'") ;
  } else {

    // Send it back
    terminal.print("You said:");
    terminal.write(param.getBuffer(), param.getLength());
    terminal.println();
  }

  // Ensure everything is sent
  terminal.flush();
}  

BLYNK_WRITE(V3)  //Extend timer. Each time Blynk button pushed, timer will restart
{
  if (param.asInt() == 1) 
  {
    timer.restartTimer(tmrSleep);  //Ensure ESP doesnt go to sleep in the middle of this.
    terminal.println(F("Timer restarted!"));
    terminal.flush();

    /*
      terminal.println("");
      WiFi.macAddress(mac);
      terminal.print("MAC: ");
      terminal.print(mac[5],HEX);
      terminal.print(":");
      terminal.print(mac[4],HEX);
      terminal.print(":");
      terminal.print(mac[3],HEX);
      terminal.print(":");
      terminal.print(mac[2],HEX);
      terminal.print(":");
      terminal.print(mac[1],HEX);
      terminal.print(":");
      terminal.println(mac[0],HEX);
      terminal.flush();    
     */
  }
}

void setup()  
{
  Serial.begin(115200);
  
  /*
  Blynk.begin(auth, ssid, password);
  while (Blynk.connect() == false) 
  {
    if (debug) {Serial.print(".");} // Wait until connected
  }
  if (debug) {Serial.println("Blynk Connected.");}
  */
  
  
  
  //OTA #############################################################################################################
    WiFi.mode(WIFI_STA);
    if (!WiFi.config(arduino_ip, gateway_ip, subnet_mask, dns_ip))
    {
      if (debug) {Serial.println("STA Failed to configure");}
    }
    
    WiFi.begin(ssid, password);  //used for static IP
    Blynk.config(auth);          //used for static IP
    //Blynk.begin(auth, ssid, password);  //used for DHCP but need to remove all the Wifi stuff.

    //Used to print MAC address of ESP - can use this to then go back and configure arduino_mac[]
    if (debug) {
      WiFi.macAddress(mac);
      Serial.print("MAC: ");
      Serial.print(mac[5],HEX);
      Serial.print(":");
      Serial.print(mac[4],HEX);
      Serial.print(":");
      Serial.print(mac[3],HEX);
      Serial.print(":");
      Serial.print(mac[2],HEX);
      Serial.print(":");
      Serial.print(mac[1],HEX);
      Serial.print(":");
      Serial.println(mac[0],HEX);
    }
    
    

    ArduinoOTA.setHostname(OTAhost);
    ArduinoOTA.onStart([]()
    {
      if (debug) {Serial.println("Start");}
    });
    ArduinoOTA.onEnd([]()
    {
      if (debug) {Serial.println("\nEnd");}
    });

    ArduinoOTA.onError([](ota_error_t error)
    {
      
      Serial.printf("Error[%u]: ", error);
      if (error == OTA_AUTH_ERROR) if (debug) {Serial.println("Auth Failed");}
      else if (error == OTA_BEGIN_ERROR) if (debug) {Serial.println("Begin Failed");}
      else if (error == OTA_CONNECT_ERROR) if (debug) {Serial.println("Connect Failed");}
      else if (error == OTA_RECEIVE_ERROR) if (debug) {Serial.println("Receive Failed");}
      else if (error == OTA_END_ERROR) if (debug) {Serial.println("End Failed");}
    });
    
    ArduinoOTA.begin();
    if (debug) {Serial.println("Ready - OTA Success!!!");}
    if (debug) {Serial.print("IP address: ");}
    if (debug) {Serial.println(WiFi.localIP());}
    MDNS.begin(OTAhost);
    httpUpdater.setup(&httpServer);
    httpServer.begin();
    MDNS.addService("http", "tcp", 80);
    String ipaddress = WiFi.localIP().toString();
    String chipID = String(ESP.getChipId(), HEX);
    char charChipID[10];
    chipID.toCharArray(charChipID, sizeof(charChipID));
    char charipaddress[16];
    ipaddress.toCharArray(charipaddress, sizeof(charipaddress));
    if (debug) {Serial.printf("Now open http://%s.local/update in your browser or \n", OTAhost);}
    if (debug) {Serial.printf("http://%s/update or http://%s.lan/update if you prefer.\n", charipaddress, charChipID);}

    while (!Blynk.connect())
    {
      delay(500);
       if (debug) {Serial.print(F("."));}
    }
    //OTA ################################################################################################################ 

   
  rtc.begin();
  if (debug) {Serial.println("RTC Begin initiated. ");}

  tmrSleep = timer.setTimeout(sleepDelayMs, goToSleep);
  //tmrSleep = timer.setInterval(sleepDelayMs, goToSleep);
  //tmrSleep = timer.setTimeout(sleepDelayMs, goToSleep);
}
/*##################################################################################*/

void goToSleep()
{
  //Blynk.notify("ESP going to sleep!");
  //terminal.println(F(""));
  //terminal.println(F(">> ESP going to sleep Zzzzz in:"));
  //terminal.flush();
  //delay(100);
  //ESP.deepSleep(0);  

  terminal.print(F(">> ESP going to sleep Zzzzz in: "));
  for (int i = 5; i >= 0; i--) 
  {
    terminal.print(i);
    terminal.print(" ");
    terminal.flush();
    delay(1000);
  }
  delay(100);
  ESP.deepSleep(0);  
  
}
/*##################################################################################*/

void loop() 
{

  Blynk.run();
  timer.run();
  ArduinoOTA.handle();          //OTA - remove if using ESP32
  httpServer.handleClient();    //OTA - remove if using ESP32
    
  if((year()!=1970) && (!notificationSent))  //only want to send notificaiton once and when RTC is running
  {  
    if (debug) {Serial.println("RTC is sync'd");}  
    doClock();
    doBatt();
    
    //BLYNK_LOG("Switch Open");
    //Blynk.email("picoware@gmail.com", "From Blynk", "Basement Window was opened recently!");
    //Blynk.notify("Basement Window was opened recently!");
    // Clear the terminal content
    //terminal.clear();
    terminal.println(F("-------------------------------------------"));
    terminal.println(message);
    //terminal.println();
    terminal.flush();
    delay(50);
    Blynk.notify(message);
    notificationSent = true;
    //start the timer
    timer.enable(tmrSleep);    
  }
 }

/*##################################################################################*/

void doClock()
{   
   char dayNum[2];
   char yearNum[3];
   char m[3]; 
   char h[3];
   char fullTime [15];
   int hr_24, hr_12;

   char dateTime[35];
     
  
   strlcpy(message, "Basement Window 2 was opened ", sizeof(message));
   strlcat(message, dayStr(weekday()),sizeof(message));
   strlcat(message, " ",sizeof(message));
   strlcat(message, getMonth(month(), result),sizeof(message));
   strlcat(message, " ",sizeof(message));
   sprintf(dayNum,"%d",day());
   strlcat(message, dayNum, sizeof(message));
   strlcat(message, " ",sizeof(message));
   sprintf(yearNum,"%d",year());
   strlcat(message, yearNum,sizeof(message));
   strlcat(message, " @ ",sizeof(message));
   
   hr_24 = hour();
   if ((hr_24 == 0) || (hr_24 == 12)) 
   {
    hr_12 = 12;
   }
   else 
   {
    hr_12 = hr_24%12;
   }
   itoa (hr_12, h, 10);
   //strlcpy(fullTime, h,sizeof(fullTime));
   strlcat(message, h, sizeof(message));
   strlcat(message, ":",sizeof(message));
   
   //add '0' before where needed.
   if (minute() < 10)
   {
    strlcat(message, "0", sizeof(message));  //add a leading 0
   }
   itoa (minute(), m, 10);
   strlcat(message, m, sizeof(message));
   
   if (hr_24 < 12) 
   {
     //ampm = ' AM';
     strlcat(message, "AM", sizeof(message));
   }
   else
   {
     //ampm = ' PM';
     strlcat(message, "PM",  sizeof(message));
   }


   //Now send only the date and time to the Last Updated widget - extract all but the 
   // "Basement Window X was opened" text hence the +28.
   strncpy(dateTime, message+28, 35);
   //dateTime[35] = '\0';   /* null character manually added */
   dateTime[strlen(dateTime)+1] = '\0';   /* null character manually added */
   Blynk.virtualWrite(V1, dateTime);
   
  
}
/*##################################################################################*/

void doBatt()
{
  char battVolts[5];
  char battPct[5];
    
  nVoltageRaw = analogRead(A0);  //reads the analog value of voltage. 0-1024 is the range.
  if (debug) {Serial.print("Raw reading on A0:");}  
  if (debug) {Serial.println( nVoltageRaw);}  
  
  /*
  fVoltage = (float)nVoltageRaw * 0.00312;  
  for(i=20; i>=0; i--) {
    if(fVoltageMatrix[i][0] >= fVoltage) {
    perc = fVoltageMatrix[i + 1][1];
    break;
   }
  }
  */

  float voltage = nVoltageRaw * (3.1 / 1024.0); // 3.1V is the nominal voltage 

  //Percent range is based on 2.5V = 0% (min acceptable for the ESP8266) and 3.1V (highest rating for 2@ 1.5V alkaline cells).  
  float pct = mapf(voltage, 2.5, 3.1, 0.0, 100.0);
  
  //float pct = voltage / 3.1 * 100;
  
  //if (debug) {Serial.print("Percent Value from matrix:");}  
  //if (debug) {Serial.println( perc);}  

  strlcat(message, " | Voltage: ",sizeof(message));
  //sprintf(battVolts,"%1.2f",fVoltage);
  sprintf(battVolts,"%1.2f",voltage);
  strlcat(message, battVolts, sizeof(message));
  strlcat(message, "V ",sizeof(message));  
  strlcat(message, "| Charge: ",sizeof(message));
  //sprintf(battPct,"%d",perc);
  sprintf(battPct,"%3.0f",pct);
  strlcat(message, battPct, sizeof(message));
  strlcat(message, "%",sizeof(message));
  
  Blynk.virtualWrite(V2, pct);
  
  
  
}

/*##################################################################################*/
float mapf(float x, float in_min, float in_max, float out_min, float out_max)
{
    return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}

/*##################################################################################*/
char *getMonth(int monthval, char * result)
{
  
  if (debug) {Serial.print("Month: ");}
  if (debug) {Serial.println(monthval);}
 
  switch (monthval) {
    case 1:
      strcpy(result, "Jan");
      break;
    case 2:
      strcpy(result, "Feb");
      break;
    case 3:
      strcpy(result, "Mar");
      break;
    case 4:
      strcpy(result, "Apr");
      break;
    case 5:
      strcpy(result, "May");
      break;
    case 6:
      strcpy(result, "Jun");
      break;
    case 7:
      strcpy(result, "Jul");
      break;
    case 8:
      strcpy(result, "Aug");
      break;
    case 9:
      strcpy(result, "Sept");
      break;
    case 10:
      strcpy(result, "Oct");
      break;
    case 11:
      strcpy(result, "Nov");
      break;
    case 12:
      strcpy(result, "Dec");
      break;
    default: 
      strcpy(result, "n/a");
      break;
  }
  return result;
}
