/*
 Sept 2021 Copyright - www.PlastiBots.com
 Usage: Source code, schematics and build information is provided to maintain the spirit of open source. 
 Per that model, you are authorized to re-use, change, modify and update the code as long as original 
 credits are maintained and published for public consumption. It may not be used for commercial, re-sale 
 or other for-profit purposes unless written consent is provided.

  CREDITS AS FOLLOWS: 
  How to convert PNG and other images:
  https://forum.arduino.cc/t/u8glib-and-bitmap-creation-display/148125
  1) Load your picture into gimp
  2) Convert it into a indexed bitmap, 2 levels, black & white, maybe use dithering
  3) Export as XBM (.xbm extension)
  
  u8g2 https://github.com/olikraus/u8g2/wiki
  https://gist.github.com/ArnauMA/15a9b70538f37dddd3ad32844a634ccb
  https://marlinfw.org/tools/u8glib/converter.html
  https://www.youtube.com/watch?v=iy89vaeMOPY
  https://randomnerdtutorials.com/esp-now-two-way-communication-esp32/
  https://github.com/JChristensen/JC_Button
  https://github.com/bnbe-club/esp-now-examples-diy-62
  https://www.instructables.com/ESP8266-with-Multiple-Analog-Sensors/

v6 - added a number of new sequences and a demo mode. Paired with RearLEDBarV13.ino
v5 - refined ADC sensor with 2 LDRs and multiplexing. Separate function as well.
v5 - added ADC sensor multiplexing for the Airbag and Seat Belt warning indicators (reading Photoresistor (LDR))
  
*/

#include <JC_Button.h>          // https://github.com/JChristensen/JC_Button
#include <Arduino.h>
#include <U8g2lib.h>
#include <espnow.h>          // for ESP-NOW
#include <ESP8266WiFi.h>     // for ESP-NOW

#include <SPI.h>


//#ifdef U8X8_HAVE_HW_SPI
//#include <SPI.h>
//#endif
//#ifdef U8X8_HAVE_HW_I2C
//#include <Wire.h>
//#endif

//DEBUG - see note in setup re TX pin and GPIO assignment.
boolean debug = false;   //Be sure to set to false when done debugging!!

const int mPlexReadPin = A0;         //for airbag and seatbelt warning LDR sensors
const int abSensorPin = D3; //D6;    //digital out to LDR1
const int seatSensorPin = D1;        //digital out to LDR2
const byte upTogglePIN(D2);          //connect a button switch from this pin to ground
    
int abState = 0;
int sbState = 0;
int LEDStripModeState = 0;
int selectedMode = 0;               //selected LED sequence mode
int startupDispMode = -1;               //one time startup setting sent from slave unit
boolean wasDoneOnce = false;
boolean doSeq = 0;                  //holding toggle up will init a LED sequence on the Slave
boolean btnHold = false;
Button upToggle(upTogglePIN);       // define the button

/*
  U8g2lib Example Overview:
    Frame Buffer Examples: clearBuffer/sendBuffer. Fast, but may not work with all Arduino boards because of RAM consumption
    Page Buffer Examples: firstPage/nextPage. Less RAM usage, should work with all Arduino boards.
    U8x8 Text Only Example: No RAM usage, direct communication with display controller. No graphics, 8x8 Text only.
*/
// OLED LCD: Please UNCOMMENT one of the contructor lines below
// The complete list is available here: https://github.com/olikraus/u8g2/wiki/u8g2setupcpp
U8G2_SH1122_256X64_F_4W_HW_SPI u8g2(U8G2_R0, /* cs= D8onNodeMCU*/ 15, /* dc=D4onNodeMCU*/ 2, /* reset=D0onNodeMCU*/ 16);        // Enable U8G2_16BIT in u8g2.h

// End of constructor list
//#######################################################################################################

// For ESP-NOW
unsigned long lastTime = 0;  
unsigned long timerDelay = 1000;  // send readings timer
unsigned long lastPingTime = 0;  
//for ESP-NOW: REPLACE WITH THE MAC Address of the receiving ESP to communicate with
//MASTER - OLED controller in console   5C:CF:7F:1B:D2:C5
//SLAVE - LED controller in trunk 5C:CF:7F:28:CD:08
//uint8_t broadcastAddress[] = {0x5C, 0xCF, 0x7F, 0x1B, 0xD2, 0xC5}; //MASTER - OLED Controller
uint8_t broadcastAddress[] = {0x5C, 0xCF, 0x7F, 0x28, 0xCD, 0x08}; //SLAVE - LED in rear


//ESP-NOW Structure to send data  Must match the receiver structure
typedef struct struct_message {
  int a1;
  int b1;
  int c1;
  int d1;
  int e1;
} struct_message;

// ESP-NOW Create a struct_message called statusReadings to hold sensor readings
struct_message myData;

struct_message dummyData;  //for sending ping to Slave unit


static const unsigned char miataLogoLG[] U8X8_PROGMEM = {
0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0xfe, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0x3f, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0,
   0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0xff, 0xff, 0x01,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff,
   0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 0xff, 0xf1, 0xff, 0x01,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xf8, 0xff, 0x7f, 0xe0, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x0f,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
   0x1f, 0xe0, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x1f, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0x07, 0xe0, 0xff, 0x01,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0xf0, 0xff, 0xff, 0x01, 0xe0, 0xff, 0x00, 0x00, 0xf8, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x3f,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0x7f,
   0x00, 0xf0, 0xff, 0x00, 0x80, 0xff, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0x1f, 0x00, 0xf0, 0xdf, 0x00,
   0xe0, 0xff, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0xfc, 0xff, 0x0f, 0x00, 0xf8, 0x6f, 0x00, 0xf8, 0xff, 0x07, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x1f, 0xe0, 0xff,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xfe, 0xff, 0x07,
   0x00, 0xf8, 0x67, 0x00, 0xfe, 0xff, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0xff, 0x03, 0x00, 0xfc, 0x37, 0x80,
   0xff, 0xff, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xf8, 0xff, 0xff, 0x03, 0x00, 0xfe, 0x13, 0xe0, 0xff, 0xff, 0x0f, 0x00,
   0x00, 0x00, 0xe0, 0x7f, 0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 0x01,
   0x00, 0xfe, 0x1b, 0xf8, 0xff, 0xff, 0x0f, 0x00, 0x00, 0x00, 0xf8, 0xff,
   0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0x7f, 0x00, 0x00, 0xff, 0x01, 0xfc,
   0x3f, 0xff, 0x0f, 0x00, 0x00, 0x00, 0xfe, 0xff, 0x00, 0x00, 0xc0, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xff, 0xff, 0x3f, 0x00, 0x80, 0xff, 0x00, 0xfe, 0x1f, 0xff, 0x0f, 0x00,
   0x00, 0x00, 0xff, 0xff, 0x01, 0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x0f, 0x00,
   0x80, 0xff, 0x80, 0xff, 0x8f, 0xff, 0x0f, 0x00, 0x00, 0x00, 0xff, 0xff,
   0x01, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x07, 0x00, 0xc0, 0xff, 0xe1, 0xff,
   0x83, 0xff, 0x0f, 0x00, 0x00, 0x00, 0xfe, 0xff, 0x01, 0x00, 0x00, 0x00,
   0xfc, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xff, 0xff, 0x03, 0x00, 0xe0, 0xff, 0xf8, 0xff, 0xc1, 0xff, 0x0f, 0xfc,
   0x0f, 0x00, 0xf8, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
   0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x03, 0x00,
   0xe0, 0x7f, 0xfc, 0xff, 0xc0, 0xff, 0x87, 0xff, 0x3f, 0x00, 0xe0, 0xff,
   0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0x01, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0x01, 0x00, 0xf0, 0x3f, 0xff, 0x3f,
   0xe0, 0xff, 0xc7, 0xff, 0xff, 0x00, 0x00, 0xfe, 0x03, 0x00, 0x60, 0x00,
   0x00, 0x00, 0xf8, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xfc, 0xff, 0x01, 0x00, 0xf8, 0x9f, 0xff, 0x1f, 0xe0, 0xff, 0xe7, 0xff,
   0xff, 0x01, 0x00, 0xf0, 0x01, 0x00, 0xf8, 0x1f, 0x00, 0x00, 0xf8, 0xff,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0x00, 0x00,
   0xfc, 0xcf, 0xff, 0x07, 0xf0, 0xff, 0xe7, 0xff, 0xff, 0x03, 0x00, 0x80,
   0x00, 0x00, 0xfe, 0x3f, 0x00, 0x00, 0xf8, 0xff, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xe0, 0x1f, 0x00, 0x00, 0xfc, 0xff, 0xff, 0x03,
   0xf0, 0xff, 0xf3, 0xff, 0xff, 0x07, 0x00, 0x00, 0x00, 0x00, 0xff, 0x7f,
   0xf8, 0x00, 0xf8, 0xff, 0x00, 0xf0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 0x01, 0xf0, 0xff, 0xfb, 0xff,
   0xff, 0x07, 0x00, 0xf8, 0x00, 0x80, 0xff, 0xff, 0xff, 0x07, 0xf8, 0xff,
   0x00, 0xfc, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xff, 0xff, 0x7f, 0x00, 0xf8, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x00, 0xff,
   0x00, 0xc0, 0xff, 0xff, 0xff, 0x07, 0xf0, 0xff, 0x00, 0xfe, 0x3f, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x1f, 0x00,
   0xf8, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x80, 0xff, 0x01, 0xe0, 0xff, 0xff,
   0xff, 0x0f, 0xf0, 0xff, 0x80, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0x0f, 0x00, 0xf8, 0xff, 0xff, 0xe7,
   0xff, 0x1f, 0x80, 0xff, 0x01, 0xf8, 0xff, 0x3f, 0xff, 0x0f, 0xf0, 0xff,
   0xc0, 0xff, 0xff, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0,
   0xff, 0xff, 0x07, 0x00, 0xf8, 0xff, 0xff, 0xc3, 0xff, 0x1f, 0x00, 0xff,
   0x03, 0xfc, 0xff, 0x0f, 0xfe, 0x1f, 0xf0, 0xff, 0xe0, 0xff, 0x7f, 0xfe,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0x03, 0x00,
   0xf8, 0xff, 0xff, 0xc3, 0xff, 0x1f, 0x00, 0xff, 0x03, 0xfe, 0xff, 0x0f,
   0xfe, 0x1f, 0xf0, 0xff, 0xf0, 0xff, 0x3f, 0xfc, 0x03, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0xe0, 0xff, 0xff, 0x01, 0x00, 0xf8, 0xff, 0xff, 0xc1,
   0xff, 0x1f, 0x00, 0xff, 0x07, 0xfe, 0xff, 0x07, 0xfe, 0x1f, 0xf0, 0xff,
   0xf9, 0xff, 0x07, 0xfc, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0,
   0xff, 0xff, 0x01, 0x00, 0xf8, 0xff, 0xff, 0xc1, 0xff, 0x1f, 0x00, 0xff,
   0x0f, 0xff, 0xff, 0x03, 0xfe, 0x3f, 0xf0, 0xff, 0xff, 0xff, 0x03, 0xf8,
   0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0xff, 0x00, 0x00,
   0xf8, 0xff, 0xff, 0xc1, 0xff, 0x1f, 0x00, 0xff, 0x9f, 0xff, 0xff, 0x01,
   0xfe, 0x3f, 0xf0, 0xff, 0xff, 0xff, 0x01, 0xf8, 0x7f, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0xf8, 0xff, 0x7f, 0x00, 0x00, 0xf8, 0xff, 0xff, 0xc0,
   0xff, 0x1f, 0x00, 0xff, 0xff, 0xff, 0x7f, 0x00, 0xfe, 0x7f, 0xe0, 0xff,
   0xff, 0xff, 0x00, 0xf8, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8,
   0xff, 0x3f, 0x00, 0x00, 0xf8, 0xff, 0xff, 0xc0, 0xff, 0x1f, 0x00, 0xff,
   0xff, 0xff, 0x3f, 0x00, 0xfc, 0xff, 0xe0, 0xff, 0xff, 0xff, 0x00, 0xf0,
   0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0x1f, 0x00, 0x00,
   0xf0, 0xff, 0x7f, 0xc0, 0xff, 0x1f, 0x00, 0xff, 0xff, 0xff, 0x1f, 0x00,
   0xfc, 0xff, 0xe1, 0xff, 0xff, 0xff, 0x00, 0xf0, 0xff, 0x01, 0x00, 0x00,
   0x00, 0x00, 0x00, 0xfe, 0xff, 0x0f, 0x00, 0x00, 0xf0, 0xff, 0x7f, 0xc0,
   0xff, 0x1f, 0x80, 0xff, 0xff, 0xff, 0x0f, 0x00, 0xfc, 0xff, 0xe7, 0xff,
   0xff, 0x7f, 0x00, 0xf0, 0xff, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe,
   0xff, 0x07, 0x00, 0x00, 0xe0, 0xff, 0x3f, 0xc0, 0xff, 0x1f, 0xe0, 0xff,
   0xff, 0xff, 0x07, 0x00, 0xfe, 0xff, 0xef, 0xff, 0xff, 0x7f, 0x00, 0xe0,
   0xff, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x03, 0x00, 0x00,
   0xc0, 0xff, 0x1f, 0xc0, 0xff, 0x1f, 0xf8, 0xff, 0xff, 0xff, 0x1f, 0x00,
   0xfe, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x00, 0xe0, 0xff, 0x07, 0x00, 0x00,
   0x00, 0x00, 0x80, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0xff, 0x0f, 0xc0,
   0xff, 0x3f, 0xfe, 0xff, 0xff, 0xff, 0x3f, 0x00, 0xff, 0xff, 0xff, 0xff,
   0xff, 0x7f, 0x00, 0xc0, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff,
   0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xfd,
   0xff, 0xff, 0xff, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0xe0,
   0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0x7f, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xf9, 0xff, 0xff, 0xff, 0xc7,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0xf0, 0xff, 0xff, 0x7f, 0x00,
   0x00, 0x00, 0xe0, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
   0xff, 0xff, 0xff, 0xf1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0x03, 0xf8, 0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 0xe0, 0xff,
   0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xe1,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0x0f, 0xe0, 0x00, 0x00, 0xf0, 0xff, 0x0f, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 0x00, 0xfc, 0xff, 0xff, 0xff,
   0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xf8, 0xff, 0x1f, 0xfc,
   0x00, 0x00, 0xf0, 0xff, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xfc, 0xff, 0xff, 0x00, 0x00, 0xfe, 0xff, 0xff, 0x1f, 0xf0, 0xff, 0xff,
   0xff, 0xff, 0xff, 0x0f, 0xe0, 0xff, 0x3f, 0xfe, 0x00, 0x00, 0xf8, 0xff,
   0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0x7f, 0x00,
   0x00, 0xf8, 0xff, 0xff, 0x0f, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0x07,
   0x00, 0xff, 0xff, 0x7f, 0x00, 0x00, 0xf8, 0xff, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0x1f, 0x00, 0x00, 0xe0, 0xff, 0xff,
   0x07, 0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 0x03, 0x00, 0xf8, 0xff, 0x3f,
   0x00, 0x00, 0xf8, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xe0, 0xff, 0x07, 0x00, 0x00, 0x80, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00,
   0x00, 0xff, 0xff, 0x00, 0x00, 0x80, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0x01, 0x00,
   0x00, 0x00, 0xfe, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x1f, 0x00,
   0x00, 0x00, 0x00, 0x00
};

static const unsigned char miataLogo[] U8X8_PROGMEM = {
   0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x7f, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
   0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xf0, 0xff, 0xfc, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x3f, 0xf8, 0x01, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xff, 0x0f, 0xfc, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0x03, 0xfc,
   0x01, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00,
   0x00, 0x00, 0x00, 0xc0, 0xff, 0x00, 0xfe, 0x80, 0xff, 0x01, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x1f, 0xfc, 0x01, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xff,
   0x00, 0xbe, 0xe0, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0xff,
   0xff, 0x03, 0x00, 0x00, 0x00, 0xfc, 0x7f, 0x00, 0x5f, 0xf0, 0xff, 0x01,
   0x00, 0xf0, 0x07, 0x00, 0xfe, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0x00,
   0xfe, 0x3f, 0x00, 0x1f, 0xfc, 0xfd, 0x01, 0x00, 0xfc, 0x07, 0x00, 0xff,
   0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0xff, 0x0f, 0x80, 0x0f, 0xfe,
   0xfc, 0x01, 0x00, 0xfc, 0x07, 0x00, 0xff, 0xff, 0xff, 0x0f, 0x00, 0x00,
   0x00, 0x00, 0xff, 0x07, 0xc0, 0x8f, 0x7f, 0xfe, 0x81, 0x01, 0xf8, 0x0f,
   0x00, 0x00, 0xfe, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0xff, 0x03, 0xc0,
   0xe7, 0x1f, 0xfe, 0xf9, 0x0f, 0xe0, 0x0f, 0x00, 0x00, 0x00, 0xfe, 0x01,
   0x00, 0x00, 0x00, 0x00, 0xfe, 0x03, 0xe0, 0xf3, 0x0f, 0xfe, 0xfd, 0x1f,
   0x00, 0x0f, 0xc0, 0x07, 0x00, 0xfe, 0x01, 0x00, 0x00, 0x00, 0x00, 0xf8,
   0x01, 0xf0, 0xff, 0x07, 0xff, 0xfc, 0x3f, 0x00, 0x00, 0xe0, 0x1f, 0x00,
   0xfe, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0x01, 0xff,
   0xfe, 0x7f, 0x00, 0x07, 0xf0, 0xff, 0x0f, 0xfe, 0x80, 0x0f, 0x00, 0x00,
   0x00, 0x00, 0x00, 0xf8, 0xff, 0x80, 0xff, 0xff, 0xff, 0xc0, 0x07, 0xf8,
   0xff, 0x0f, 0xfe, 0xe0, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x7f,
   0x80, 0xff, 0x9f, 0xff, 0xc0, 0x0f, 0xfc, 0xcf, 0x1f, 0xfe, 0xf0, 0xff,
   0x07, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x3f, 0x80, 0xff, 0x9f, 0xff, 0xc0,
   0x0f, 0xfe, 0xc7, 0x1f, 0xfe, 0xf9, 0x9f, 0x0f, 0x00, 0x00, 0x00, 0x00,
   0xfe, 0x1f, 0x80, 0xff, 0x8f, 0xff, 0xc0, 0x1f, 0xff, 0xc3, 0x3f, 0xfe,
   0xff, 0x07, 0x3f, 0x00, 0x00, 0x00, 0x00, 0xff, 0x0f, 0x80, 0xff, 0x8f,
   0xff, 0xc0, 0xbf, 0xff, 0xc1, 0x3f, 0xfc, 0xff, 0x03, 0x7f, 0x00, 0x00,
   0x00, 0x00, 0xff, 0x07, 0x00, 0xff, 0x8f, 0xff, 0xc0, 0xff, 0xff, 0x80,
   0x7f, 0xfc, 0xff, 0x03, 0xfe, 0x00, 0x00, 0x00, 0x80, 0xff, 0x03, 0x00,
   0xff, 0x87, 0xff, 0xc0, 0xff, 0x7f, 0x80, 0xff, 0xfc, 0xff, 0x01, 0xfe,
   0x01, 0x00, 0x00, 0x80, 0xff, 0x01, 0x00, 0xfe, 0x83, 0xff, 0xf0, 0xff,
   0x7f, 0xc0, 0xff, 0xff, 0xff, 0x01, 0xfe, 0x01, 0x00, 0x00, 0xc0, 0xff,
   0x00, 0x00, 0xfc, 0x81, 0xff, 0xfc, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff,
   0x01, 0xfc, 0x07, 0x00, 0x00, 0xe0, 0x7f, 0x00, 0x00, 0x00, 0x00, 0xff,
   0x7f, 0xff, 0xff, 0xe3, 0xff, 0xff, 0xff, 0x03, 0xfe, 0xbf, 0x00, 0x00,
   0xe0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0xff, 0x7f, 0xfe, 0xff, 0xff, 0xff,
   0xff, 0xff, 0x07, 0xff, 0xff, 0x00, 0x00, 0xf0, 0x1f, 0x00, 0x00, 0x00,
   0x00, 0xfe, 0x3f, 0xf0, 0xff, 0xff, 0xfd, 0xff, 0xff, 0xff, 0xe3, 0x7f,
   0x38, 0x00, 0xf8, 0x0f, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x3f, 0x00, 0xfe,
   0xff, 0xc0, 0xff, 0xff, 0xff, 0x80, 0xff, 0x3f, 0x00, 0xf8, 0x03, 0x00,
   0x00, 0x00, 0x00, 0xf8, 0x0f, 0x00, 0xf8, 0x7f, 0x00, 0x00, 0xf0, 0x7f,
   0x00, 0xf8, 0x0f, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x03,
   0x00, 0xe0, 0x1f, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x04 
  };


//static const unsigned char PROGMEM mx5Logo[] = {
static const unsigned char mx5Logo[] U8X8_PROGMEM = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x1f,
   0x00, 0xfc, 0xe0, 0x03, 0x00, 0x00, 0xf0, 0x3f, 0x00, 0xc0, 0xff, 0xff,
   0xff, 0x0f, 0x00, 0x00, 0x00, 0xfc, 0x3f, 0xc0, 0xff, 0xe3, 0x1f, 0x00,
   0x80, 0xff, 0x0f, 0x00, 0xf0, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00,
   0xff, 0x1f, 0xf0, 0xff, 0x81, 0x7f, 0x00, 0xf8, 0xff, 0x01, 0x00, 0xf8,
   0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0x80, 0xff, 0x0f, 0xfc, 0xff, 0x01,
   0xff, 0x01, 0xff, 0x3f, 0x00, 0x00, 0xfe, 0x1f, 0x00, 0x00, 0x00, 0x00,
   0x00, 0xe0, 0xff, 0x0f, 0xff, 0xff, 0x00, 0xfe, 0xff, 0xff, 0x07, 0x00,
   0x00, 0xff, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0xc7, 0xff,
   0x7f, 0x00, 0xf8, 0xff, 0xff, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0x0f,
   0x00, 0x00, 0x00, 0xfc, 0xff, 0xe3, 0xff, 0x7f, 0x00, 0xf0, 0xff, 0x1f,
   0x00, 0xff, 0xc3, 0xff, 0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 0xff, 0xfd,
   0xf9, 0xef, 0x3f, 0x00, 0xf0, 0xff, 0x03, 0xf0, 0xff, 0xe1, 0xff, 0xff,
   0xff, 0xff, 0x00, 0x00, 0x80, 0x7f, 0xfe, 0xfd, 0xe7, 0x1f, 0x00, 0xfc,
   0xff, 0x01, 0xfe, 0x7f, 0xc0, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0xe0,
   0x3f, 0xff, 0xff, 0xf1, 0x1f, 0x80, 0xff, 0xff, 0x07, 0xfe, 0x0f, 0x00,
   0x00, 0x00, 0xf0, 0xff, 0x01, 0x00, 0xf0, 0x0f, 0xff, 0x7f, 0xf8, 0x0f,
   0xe0, 0xff, 0xff, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0x00,
   0x00, 0xfc, 0x87, 0xff, 0x3f, 0xf8, 0x0f, 0xf8, 0xff, 0xff, 0x1f, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0x00, 0x00, 0xfe, 0xc1, 0xff, 0x0f,
   0xfc, 0x07, 0xff, 0x7f, 0xf8, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff,
   0x3f, 0x00, 0x80, 0xff, 0xe0, 0xff, 0x03, 0xfe, 0xc3, 0xff, 0x0f, 0xf0,
   0xff, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0x0f, 0x00, 0xc0, 0x3f, 0xe0,
   0xff, 0x01, 0xfe, 0xfb, 0xff, 0x03, 0xc0, 0xff, 0x01, 0x00, 0x00, 0x80,
   0xff, 0xff, 0x01, 0x00, 0xf0, 0x1f, 0xf0, 0x7f, 0x00, 0xff, 0xff, 0x7f,
   0x00, 0x80, 0xff, 0x07, 0x00, 0xfe, 0xff, 0xff, 0x7f, 0x00, 0x00, 0xf8,
   0x07, 0xf8, 0x1f, 0x00, 0xff, 0xff, 0x0f, 0x00, 0x00, 0xfe, 0x0f, 0xc0,
   0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 0xfe, 0x01, 0xfc, 0x03, 0x00, 0xff,
   0xff, 0x00, 0x00, 0x00, 0xf0, 0x0f, 0xe0, 0xff, 0xff, 0x1f, 0x00, 0x00,
   0x00, 0x3f, 0x00, 0x30, 0x00, 0x00, 0xf0, 0x03, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const unsigned char MX5Silhouette[] U8X8_PROGMEM = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x01,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xc0, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x31, 0x00, 0x00, 0x00, 0x00, 0x3f,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0xc0, 0x31, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x39, 0x00,
   0x00, 0x00, 0x00, 0xf8, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x39, 0x00, 0x00, 0x00, 0x00, 0xf0,
   0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0xf0, 0x3d, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x3f, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x3d, 0x00,
   0x00, 0x00, 0x00, 0x80, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xff, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0xf8, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x0f, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x1e, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xf8, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xf0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0,
   0xff, 0xfc, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0x03, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0x7d, 0x0f, 0x00,
   0x00, 0x00, 0x00, 0xe0, 0x81, 0xff, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xf0, 0xff, 0xff, 0x03, 0x80, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0,
   0x07, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff,
   0x1f, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x1f, 0xfe, 0xff, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x07, 0x78, 0x00,
   0x00, 0x00, 0x00, 0xf8, 0x3f, 0xf8, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8,
   0x3f, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0x7f, 0xe0, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xf0, 0xff, 0x07, 0x00, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x01,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0x00, 0x00,
   0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0x7f, 0x00, 0xf8, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x80, 0x3f, 0x00, 0x00, 0xc0, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 0x00, 0x00, 0xe0, 0xff,
   0x1f, 0x00, 0xfe, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x0e, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0xc0, 0xff, 0x00, 0x00, 0xf0, 0x7f,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x7c, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x80, 0x3f, 0x00, 0x00, 0xc0, 0xff, 0x01, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0xfe,
   0xff, 0xff, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e,
   0x00, 0x00, 0x00, 0xff, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 0xff, 0x03, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xf0, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc,
   0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x80, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
static const unsigned char airbag[] U8X8_PROGMEM = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00,
   0x58, 0x78, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x70, 0x38, 0x00, 0x00,
   0xc8, 0x4c, 0x00, 0x00, 0x88, 0x07, 0x00, 0x00, 0x00, 0x03, 0x1c, 0x00,
   0x80, 0x07, 0x1e, 0x00, 0xc8, 0x4c, 0x1e, 0x00, 0x68, 0x58, 0x8c, 0x01,
   0x30, 0x30, 0xc0, 0x00, 0x38, 0x70, 0x4e, 0x00, 0xc8, 0x4f, 0x1e, 0x00,
   0x00, 0x00, 0x0f, 0x00, 0x00, 0x80, 0xcf, 0x03, 0x00, 0x20, 0xe7, 0x07,
   0x00, 0x6f, 0x67, 0x0c, 0x80, 0x4f, 0x33, 0x0c, 0xc0, 0x5f, 0x02, 0x0c,
   0xe0, 0xd1, 0x00, 0x0e, 0xe0, 0x80, 0x00, 0x07, 0x70, 0x80, 0x80, 0x03,
   0x38, 0x80, 0xc1, 0x01, 0x30, 0x00, 0xe1, 0x00, 0x00, 0x00, 0xe0, 0x0f,
   0x00, 0x00, 0xe0, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const unsigned char seatbeltWarning[] U8X8_PROGMEM = {
   0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x7c, 0x80, 0x07, 0x00,
   0x7c, 0x80, 0x0f, 0x00, 0x7c, 0x80, 0x0f, 0x00, 0x78, 0x80, 0x8f, 0x00,
   0x38, 0x80, 0xc7, 0x00, 0x38, 0x00, 0x67, 0x00, 0x30, 0x80, 0x37, 0x00,
   0x30, 0xe0, 0x07, 0x00, 0x00, 0xf0, 0x33, 0x00, 0x00, 0xf0, 0x39, 0x00,
   0x78, 0xf0, 0x7c, 0x00, 0x7c, 0x30, 0x7e, 0x00, 0x30, 0x18, 0x7f, 0x00,
   0x00, 0x88, 0xff, 0x00, 0x00, 0xc0, 0xff, 0x00, 0x00, 0xe0, 0xff, 0x00,
   0x00, 0xf2, 0xff, 0x00, 0x00, 0x03, 0x80, 0x00, 0x80, 0xc7, 0x1f, 0x03,
   0xc0, 0xfb, 0xfd, 0x0e, 0xc0, 0x38, 0x60, 0x18, 0x00, 0x30, 0x70, 0x00,
   0x00, 0x70, 0x30, 0x00, 0x00, 0x60, 0x30, 0x00, 0x00, 0x60, 0x38, 0x00,
   0x00, 0xc0, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const unsigned char LEDStripOn[] U8X8_PROGMEM = {
   0x00, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0x07, 0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0x1f, 0x00, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00, 0xf8, 0x01, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x7c, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x00,
   0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xf0, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe0, 0x01, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xe0, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x01, 0x0f, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x0f, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03,
   0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xc0, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xc0, 0x03, 0x0f, 0x00, 0xfe, 0x3f, 0x00, 0xff, 0x81, 0xff,
   0x03, 0xe0, 0xff, 0x03, 0xc0, 0x03, 0x0f, 0x00, 0xff, 0x7f, 0x80, 0xff,
   0x83, 0xff, 0x07, 0xf0, 0xff, 0x07, 0xc0, 0x03, 0x0f, 0x80, 0xff, 0xff,
   0xc0, 0xff, 0x87, 0xff, 0x0f, 0xf8, 0xff, 0x0f, 0xc0, 0x03, 0x0f, 0x80,
   0xff, 0xff, 0xc0, 0xff, 0x8f, 0xff, 0x1f, 0xf8, 0xff, 0x0f, 0xc0, 0x03,
   0x0f, 0x80, 0xff, 0xff, 0xc0, 0xff, 0x8f, 0xff, 0x1f, 0xf8, 0xff, 0x0f,
   0xc0, 0x03, 0x0f, 0x80, 0xff, 0xff, 0xc0, 0x83, 0x8f, 0x07, 0x1f, 0xf8,
   0xff, 0x0f, 0xc0, 0x03, 0x0f, 0x80, 0xff, 0xff, 0xc0, 0x83, 0x8f, 0x07,
   0x1f, 0xf8, 0xff, 0x0f, 0xc0, 0x03, 0x0f, 0x80, 0xff, 0xff, 0xc0, 0x83,
   0x8f, 0x07, 0x1f, 0xf8, 0xff, 0x0f, 0xc0, 0x03, 0x0f, 0x80, 0xff, 0xff,
   0xc0, 0x83, 0x8f, 0x07, 0x1f, 0xf8, 0xff, 0x0f, 0xc0, 0x03, 0x0f, 0x80,
   0xff, 0xff, 0xc0, 0x83, 0x8f, 0x07, 0x1f, 0xf8, 0xff, 0x0f, 0xc0, 0x03,
   0x0f, 0x80, 0xff, 0xff, 0xc0, 0x83, 0x8f, 0x07, 0x1f, 0xf8, 0xff, 0x0f,
   0xc0, 0x03, 0x0f, 0x80, 0xff, 0xff, 0xc0, 0x83, 0x8f, 0x07, 0x1f, 0xf8,
   0xff, 0x0f, 0xc0, 0x03, 0x0f, 0x80, 0xff, 0xff, 0xc0, 0xff, 0x8f, 0x07,
   0x1f, 0xf8, 0xff, 0x0f, 0xc0, 0x03, 0x0f, 0x80, 0xff, 0xff, 0xc0, 0xff,
   0x8f, 0x07, 0x1f, 0xf8, 0xff, 0x0f, 0xc0, 0x03, 0x0f, 0x80, 0xff, 0xff,
   0xc0, 0xff, 0x87, 0x07, 0x1f, 0xf8, 0xff, 0x0f, 0xc0, 0x03, 0x0f, 0x00,
   0xff, 0x7f, 0x80, 0xff, 0x83, 0x07, 0x1f, 0xf0, 0xff, 0x07, 0xc0, 0x03,
   0x0f, 0x00, 0xfe, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 0x03,
   0xc0, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xc0, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x0f, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x0e, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x01,
   0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xe0, 0x01, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe0, 0x01, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xf0, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0xf8, 0x01, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0xf0, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00,
   0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0x0f, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0x07, 0x00, 0x00, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0x7f, 0x00, 0x00 
   };

static const unsigned char LEDStripOff[] U8X8_PROGMEM = {   
   0x00, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0x07, 0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0x1f, 0x00, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00, 0xf8, 0x01, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x7c, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x00,
   0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xf0, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe0, 0x01, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xe0, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x01, 0x0f, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x0f, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03,
   0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xc0, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xc0, 0x03, 0x0f, 0xe0, 0xff, 0x03, 0xfc, 0x03, 0xfe, 0x0f,
   0xff, 0x07, 0xfe, 0x3f, 0xc0, 0x03, 0x0f, 0xf0, 0xff, 0x07, 0xfe, 0x0f,
   0xff, 0x9f, 0xff, 0x0f, 0xff, 0x7f, 0xc0, 0x03, 0x0f, 0xf8, 0xff, 0x0f,
   0xff, 0x1f, 0xff, 0x9f, 0xff, 0x8f, 0xff, 0xff, 0xc0, 0x03, 0x0f, 0xf8,
   0xff, 0x8f, 0xff, 0x1f, 0xff, 0x9f, 0xff, 0x8f, 0xff, 0xff, 0xc0, 0x03,
   0x0f, 0x78, 0x00, 0x8f, 0xff, 0x1f, 0xff, 0x8f, 0xff, 0x87, 0x07, 0xf0,
   0xc0, 0x03, 0x0f, 0x78, 0x00, 0x8f, 0x0f, 0x1f, 0x1f, 0x80, 0x0f, 0x80,
   0x07, 0xf0, 0xc0, 0x03, 0x0f, 0x78, 0x00, 0x8f, 0x0f, 0x1f, 0x1f, 0x80,
   0x0f, 0x80, 0x07, 0xf0, 0xc0, 0x03, 0x0f, 0x78, 0x00, 0x8f, 0x0f, 0x1f,
   0xff, 0x87, 0xff, 0x83, 0x07, 0xf0, 0xc0, 0x03, 0x0f, 0x78, 0x00, 0x8f,
   0x0f, 0x1f, 0xff, 0x87, 0xff, 0x83, 0x07, 0xf0, 0xc0, 0x03, 0x0f, 0x78,
   0x00, 0x8f, 0x0f, 0x1f, 0xff, 0x87, 0xff, 0x83, 0x07, 0xf0, 0xc0, 0x03,
   0x0f, 0x78, 0x00, 0x8f, 0x0f, 0x1f, 0xff, 0x87, 0xff, 0x83, 0x07, 0xf0,
   0xc0, 0x03, 0x0f, 0x78, 0x00, 0x8f, 0x0f, 0x1f, 0x1f, 0x80, 0x0f, 0x80,
   0x07, 0xf0, 0xc0, 0x03, 0x0f, 0x78, 0x00, 0x8f, 0xff, 0x1f, 0x1f, 0x80,
   0x0f, 0x80, 0x07, 0xf0, 0xc0, 0x03, 0x0f, 0xf8, 0xff, 0x8f, 0xff, 0x1f,
   0x1f, 0x80, 0x0f, 0x80, 0xff, 0xff, 0xc0, 0x03, 0x0f, 0xf8, 0xff, 0x0f,
   0xff, 0x0f, 0x1f, 0x80, 0x0f, 0x80, 0xff, 0xff, 0xc0, 0x03, 0x0f, 0xf0,
   0xff, 0x07, 0xfe, 0x07, 0x1f, 0x80, 0x0f, 0x00, 0xff, 0x7f, 0xc0, 0x03,
   0x0f, 0xe0, 0xff, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x3f,
   0xc0, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xc0, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x0f, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x0e, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x01,
   0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xe0, 0x01, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe0, 0x01, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xf0, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0xf8, 0x01, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0xf0, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00,
   0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0x0f, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0x07, 0x00, 0x00, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0x7f, 0x00, 0x00  
};

static const unsigned char LEDStripActive[] U8X8_PROGMEM = {   
  0x00, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0x07, 0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0x1f, 0x00, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00, 0xf8, 0x01, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x7c, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x00,
   0x3c, 0x0c, 0x80, 0xc1, 0x00, 0x18, 0x0c, 0x80, 0x01, 0x00, 0x00, 0x00,
   0xf0, 0x00, 0x1e, 0x1e, 0xc0, 0xe3, 0x01, 0x3c, 0x1e, 0xc0, 0x03, 0x00,
   0x00, 0x00, 0xe0, 0x01, 0x1e, 0x3e, 0xe0, 0xe3, 0x03, 0x3e, 0x3e, 0xe0,
   0x03, 0x00, 0x00, 0x00, 0xe0, 0x01, 0x0e, 0x7c, 0xf0, 0xc1, 0x07, 0x1f,
   0x7c, 0xf0, 0x01, 0x00, 0x00, 0x00, 0xc0, 0x01, 0x0f, 0x78, 0xf0, 0x80,
   0x07, 0x0f, 0x78, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x0f, 0x70,
   0x70, 0x00, 0x07, 0x07, 0x70, 0x70, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03,
   0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xc0, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xc0, 0x03, 0x0f, 0xfc, 0xff, 0x81, 0xff, 0x0f, 0xf8, 0xff,
   0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x0f, 0xfe, 0xff, 0xc3, 0xff, 0x1f,
   0xfc, 0xff, 0x01, 0x08, 0x00, 0x08, 0xc0, 0x03, 0x0f, 0xfe, 0xff, 0xe3,
   0xff, 0x3f, 0xfe, 0xff, 0x03, 0x0c, 0x00, 0x18, 0xc0, 0x03, 0x0f, 0xfe,
   0xff, 0xe3, 0xff, 0x3f, 0xfe, 0xff, 0x03, 0x0e, 0x00, 0x78, 0xc0, 0x03,
   0x0f, 0xfe, 0xff, 0xe3, 0xff, 0x3f, 0xfe, 0xff, 0x03, 0xff, 0xff, 0xff,
   0xc0, 0x03, 0x0f, 0xfe, 0xff, 0xe3, 0xff, 0x3f, 0xfe, 0xff, 0xc3, 0xff,
   0xff, 0xff, 0xc1, 0x03, 0x0f, 0xfe, 0xff, 0xe3, 0xff, 0x3f, 0xfe, 0xff,
   0xe3, 0xff, 0xff, 0xff, 0xc7, 0x03, 0x0f, 0xfe, 0xff, 0xe3, 0xff, 0x3f,
   0xfe, 0xff, 0xf3, 0xff, 0xff, 0xff, 0xcf, 0x03, 0x0f, 0xfe, 0xff, 0xe3,
   0xff, 0x3f, 0xfe, 0xff, 0xfb, 0xff, 0xff, 0xff, 0xdf, 0x03, 0x0f, 0xfe,
   0xff, 0xe3, 0xff, 0x3f, 0xfe, 0xff, 0xf3, 0xff, 0xff, 0xff, 0xcf, 0x03,
   0x0f, 0xfe, 0xff, 0xe3, 0xff, 0x3f, 0xfe, 0xff, 0xe3, 0xff, 0xff, 0xff,
   0xc7, 0x03, 0x0f, 0xfe, 0xff, 0xe3, 0xff, 0x3f, 0xfe, 0xff, 0xc3, 0xff,
   0xff, 0xff, 0xc3, 0x03, 0x0f, 0xfe, 0xff, 0xe3, 0xff, 0x3f, 0xfe, 0xff,
   0x83, 0xff, 0xff, 0xff, 0xc1, 0x03, 0x0f, 0xfe, 0xff, 0xe3, 0xff, 0x3f,
   0xfe, 0xff, 0x03, 0x0f, 0x00, 0x78, 0xc0, 0x03, 0x0f, 0xfe, 0xff, 0xe3,
   0xff, 0x3f, 0xfe, 0xff, 0x03, 0x0e, 0x00, 0x38, 0xc0, 0x03, 0x0f, 0xfe,
   0xff, 0xc3, 0xff, 0x1f, 0xfc, 0xff, 0x01, 0x0c, 0x00, 0x18, 0xc0, 0x03,
   0x0f, 0xfc, 0xff, 0x81, 0xff, 0x0f, 0xf8, 0xff, 0x00, 0x08, 0x00, 0x08,
   0xc0, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xc0, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x0f, 0x70, 0x70, 0x00, 0x07, 0x07,
   0x70, 0x70, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x0f, 0x78, 0xf0, 0x80,
   0x07, 0x0f, 0x78, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x0e, 0x7c,
   0xf0, 0xc1, 0x07, 0x1f, 0x7c, 0xf0, 0x01, 0x00, 0x00, 0x00, 0xc0, 0x01,
   0x1e, 0x3e, 0xe0, 0xe3, 0x03, 0x3e, 0x3e, 0xe0, 0x03, 0x00, 0x00, 0x00,
   0xe0, 0x01, 0x1e, 0x1e, 0xc0, 0xe3, 0x01, 0x3c, 0x1e, 0xc0, 0x03, 0x00,
   0x00, 0x00, 0xe0, 0x01, 0x3c, 0x0c, 0x80, 0xc1, 0x00, 0x18, 0x0c, 0x80,
   0x01, 0x00, 0x00, 0x00, 0xf0, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0xf8, 0x01, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0xf0, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00,
   0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0x0f, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0x07, 0x00, 0x00, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0x7f, 0x00, 0x00
};


static const unsigned char LEDStripBraking[] U8X8_PROGMEM = {   
0x00, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0x07, 0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0x1f, 0x00, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00, 0xf8, 0x01, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x7c, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x00,
   0x3c, 0x00, 0x03, 0x60, 0x30, 0x00, 0x06, 0x03, 0x60, 0x30, 0x00, 0x06,
   0xf0, 0x00, 0x1e, 0x80, 0x07, 0xf0, 0x78, 0x00, 0x8f, 0x07, 0xf0, 0x78,
   0x00, 0x0f, 0xe0, 0x01, 0x1e, 0x80, 0x0f, 0xf8, 0xf8, 0x80, 0x8f, 0x0f,
   0xf8, 0xf8, 0x80, 0x0f, 0xe0, 0x01, 0x0e, 0x00, 0x1f, 0x7c, 0xf0, 0xc1,
   0x07, 0x1f, 0x7c, 0xf0, 0xc1, 0x07, 0xc0, 0x01, 0x0f, 0x00, 0x1e, 0x3c,
   0xe0, 0xc1, 0x03, 0x1e, 0x3c, 0xe0, 0xc1, 0x03, 0xc0, 0x03, 0x0f, 0x00,
   0x1c, 0x1c, 0xc0, 0xc1, 0x01, 0x1c, 0x1c, 0xc0, 0xc1, 0x01, 0xc0, 0x03,
   0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xc0, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xc0, 0x03, 0x0f, 0x00, 0xfe, 0x3f, 0xe0, 0xff, 0x03, 0xfe,
   0x3f, 0xe0, 0xff, 0x03, 0xc0, 0x03, 0x0f, 0x00, 0xff, 0x7f, 0xf0, 0xff,
   0x07, 0xff, 0x7f, 0xf0, 0xff, 0x07, 0xc0, 0x03, 0x0f, 0x80, 0xff, 0xff,
   0xf8, 0xff, 0x8f, 0xff, 0xff, 0xf8, 0xff, 0x0f, 0xc0, 0x03, 0x0f, 0x80,
   0xff, 0xff, 0xf8, 0xff, 0x8f, 0xff, 0xff, 0xf8, 0xff, 0x0f, 0xc0, 0x03,
   0x0f, 0x80, 0x07, 0xf0, 0x78, 0x00, 0x8f, 0x07, 0xf0, 0x78, 0x00, 0x0f,
   0xc0, 0x03, 0x0f, 0x80, 0x07, 0xf0, 0x78, 0x00, 0x8f, 0x07, 0xf0, 0x78,
   0x00, 0x0f, 0xc0, 0x03, 0x0f, 0x80, 0x07, 0xf0, 0x78, 0x00, 0x8f, 0x07,
   0xf0, 0x78, 0x00, 0x0f, 0xc0, 0x03, 0x0f, 0x80, 0x07, 0xf0, 0x78, 0x00,
   0x8f, 0x07, 0xf0, 0x78, 0x00, 0x0f, 0xc0, 0x03, 0x0f, 0x80, 0x07, 0xf0,
   0x78, 0x00, 0x8f, 0x07, 0xf0, 0x78, 0x00, 0x0f, 0xc0, 0x03, 0x0f, 0x80,
   0x07, 0xf0, 0x78, 0x00, 0x8f, 0x07, 0xf0, 0x78, 0x00, 0x0f, 0xc0, 0x03,
   0x0f, 0x80, 0x07, 0xf0, 0x78, 0x00, 0x8f, 0x07, 0xf0, 0x78, 0x00, 0x0f,
   0xc0, 0x03, 0x0f, 0x80, 0x07, 0xf0, 0x78, 0x00, 0x8f, 0x07, 0xf0, 0x78,
   0x00, 0x0f, 0xc0, 0x03, 0x0f, 0x80, 0x07, 0xf0, 0x78, 0x00, 0x8f, 0x07,
   0xf0, 0x78, 0x00, 0x0f, 0xc0, 0x03, 0x0f, 0x80, 0xff, 0xff, 0xf8, 0xff,
   0x8f, 0xff, 0xff, 0xf8, 0xff, 0x0f, 0xc0, 0x03, 0x0f, 0x80, 0xff, 0xff,
   0xf8, 0xff, 0x8f, 0xff, 0xff, 0xf8, 0xff, 0x0f, 0xc0, 0x03, 0x0f, 0x00,
   0xff, 0x7f, 0xf0, 0xff, 0x07, 0xff, 0x7f, 0xf0, 0xff, 0x07, 0xc0, 0x03,
   0x0f, 0x00, 0xfe, 0x3f, 0xe0, 0xff, 0x03, 0xfe, 0x3f, 0xe0, 0xff, 0x03,
   0xc0, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xc0, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x0f, 0x00, 0x1c, 0x1c, 0xc0, 0xc1,
   0x01, 0x1c, 0x1c, 0xc0, 0xc1, 0x01, 0xc0, 0x03, 0x0f, 0x00, 0x1e, 0x3c,
   0xe0, 0xc1, 0x03, 0x1e, 0x3c, 0xe0, 0xc1, 0x03, 0xc0, 0x03, 0x0e, 0x00,
   0x1f, 0x7c, 0xf0, 0xc1, 0x07, 0x1f, 0x7c, 0xf0, 0xc1, 0x07, 0xc0, 0x01,
   0x1e, 0x80, 0x0f, 0xf8, 0xf8, 0x80, 0x8f, 0x0f, 0xf8, 0xf8, 0x80, 0x0f,
   0xe0, 0x01, 0x1e, 0x80, 0x07, 0xf0, 0x78, 0x00, 0x8f, 0x07, 0xf0, 0x78,
   0x00, 0x0f, 0xe0, 0x01, 0x3c, 0x00, 0x03, 0x60, 0x30, 0x00, 0x06, 0x03,
   0x60, 0x30, 0x00, 0x06, 0xf0, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0xf8, 0x01, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0xf0, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00,
   0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0x0f, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0x07, 0x00, 0x00, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0x7f, 0x00, 0x00  
};
static const unsigned char LEDStripModeKITT[] U8X8_PROGMEM = {  
   0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 0x00,
   0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00,
   0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,
   0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x00,
   0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x01,
   0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x01,
   0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03,
   0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x03,
   0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x03,
   0x07, 0xc0, 0xe1, 0x01, 0x0e, 0xf0, 0x3f, 0xe0, 0x7f, 0x00, 0x80, 0x03,
   0x07, 0xc0, 0xf1, 0x00, 0x0e, 0xf0, 0x3f, 0xe0, 0x7f, 0x00, 0x80, 0x03,
   0x07, 0xc0, 0x79, 0x00, 0x0e, 0xf0, 0x3f, 0xe0, 0x7f, 0x00, 0x80, 0x03,
   0x07, 0xc0, 0x7d, 0x00, 0x0e, 0x80, 0x07, 0x00, 0x0f, 0x00, 0x80, 0x03,
   0x07, 0xc0, 0x3f, 0x00, 0x0e, 0x80, 0x07, 0x00, 0x0f, 0x00, 0x80, 0x03,
   0x07, 0xc0, 0x1f, 0x00, 0x0e, 0x80, 0x07, 0x00, 0x0f, 0x00, 0x80, 0x03,
   0x07, 0xc0, 0x3f, 0x00, 0x0e, 0x80, 0x07, 0x00, 0x0f, 0x00, 0x80, 0x03,
   0x07, 0xc0, 0x3f, 0x00, 0x0e, 0x80, 0x07, 0x00, 0x0f, 0x00, 0x80, 0x03,
   0x07, 0xc0, 0x7b, 0x00, 0x0e, 0x80, 0x07, 0x00, 0x0f, 0x00, 0x80, 0x03,
   0x07, 0xc0, 0xf1, 0x38, 0x8e, 0x83, 0x07, 0x07, 0x0f, 0x0e, 0x80, 0x03,
   0x07, 0xc0, 0xf1, 0x38, 0x8e, 0x83, 0x07, 0x07, 0x0f, 0x0e, 0x80, 0x03,
   0x07, 0xc0, 0xe1, 0x39, 0x8e, 0x83, 0x07, 0x07, 0x0f, 0x0e, 0x80, 0x03,
   0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x03,
   0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x03,
   0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x03,
   0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03,
   0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x01,
   0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x01,
   0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x00,
   0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x00,
   0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00,
   0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x00 
};

static const unsigned char LEDStripModeBounce[] U8X8_PROGMEM = {  
0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 0x00,
   0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00,
   0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,
   0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x00,
   0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x01,
   0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x01,
   0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03,
   0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x03,
   0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x03,
   0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x03,
   0x07, 0xff, 0x81, 0x3f, 0x1c, 0x8e, 0xff, 0xc0, 0x1f, 0xfc, 0x81, 0x03,
   0x07, 0xff, 0xc3, 0x7f, 0x1c, 0x8e, 0xff, 0xe1, 0x1f, 0xfe, 0x81, 0x03,
   0x07, 0xff, 0xe7, 0x7f, 0x1c, 0x8e, 0xff, 0xf1, 0x1f, 0xff, 0x81, 0x03,
   0x07, 0x07, 0xe7, 0x70, 0x1c, 0x8e, 0xc3, 0x71, 0x00, 0x07, 0x80, 0x03,
   0x07, 0x07, 0xe3, 0x70, 0x1c, 0x8e, 0xc3, 0x71, 0x00, 0x07, 0x80, 0x03,
   0x07, 0xff, 0xe3, 0x70, 0x1c, 0x8e, 0xc3, 0x71, 0x00, 0xff, 0x81, 0x03,
   0x07, 0xff, 0xe3, 0x70, 0x1c, 0x8e, 0xc3, 0x71, 0x00, 0xff, 0x81, 0x03,
   0x07, 0x07, 0xe3, 0x70, 0x1c, 0x8e, 0xc3, 0x71, 0x00, 0x07, 0x80, 0x03,
   0x07, 0x07, 0xe7, 0x70, 0x1c, 0x8e, 0xc3, 0x71, 0x00, 0x07, 0x80, 0x03,
   0x07, 0xff, 0xe7, 0x7f, 0xfc, 0x8f, 0xc3, 0xf1, 0x1f, 0xff, 0x81, 0x03,
   0x07, 0xff, 0xc3, 0x7f, 0xf8, 0x8f, 0xc3, 0xe1, 0x1f, 0xfe, 0x81, 0x03,
   0x07, 0xff, 0x81, 0x3f, 0xf0, 0x87, 0xc3, 0xc1, 0x1f, 0xfc, 0x81, 0x03,
   0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x03,
   0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x03,
   0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03,
   0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x01,
   0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x01,
   0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x00,
   0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x00,
   0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00,
   0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x00
   };

static const unsigned char LEDStripModeBoth[] U8X8_PROGMEM = { 
   0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 0x00,
   0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00,
   0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,
   0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x00,
   0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x01,
   0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x01,
   0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03,
   0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x03,
   0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x03,
   0x07, 0x00, 0xf0, 0x0f, 0xf0, 0x83, 0xff, 0x71, 0x38, 0x00, 0x80, 0x03,
   0x07, 0x00, 0xf8, 0x3f, 0xfc, 0x8f, 0xff, 0x79, 0x78, 0x00, 0x80, 0x03,
   0x07, 0x00, 0xf8, 0x7f, 0xfc, 0x8f, 0xff, 0x79, 0x78, 0x00, 0x80, 0x03,
   0x07, 0x00, 0xf8, 0x7f, 0xfe, 0x9f, 0xff, 0x79, 0x78, 0x00, 0x80, 0x03,
   0x07, 0x00, 0x78, 0x78, 0x1e, 0x1e, 0x3c, 0x78, 0x78, 0x00, 0x80, 0x03,
   0x07, 0x00, 0xf8, 0x7f, 0x1e, 0x1e, 0x3c, 0xf8, 0x7f, 0x00, 0x80, 0x03,
   0x07, 0x00, 0xf8, 0x3f, 0x1e, 0x1e, 0x3c, 0xf8, 0x7f, 0x00, 0x80, 0x03,
   0x07, 0x00, 0xf8, 0x3f, 0x1e, 0x1e, 0x3c, 0xf8, 0x7f, 0x00, 0x80, 0x03,
   0x07, 0x00, 0x78, 0x78, 0x1e, 0x1e, 0x3c, 0xf8, 0x7f, 0x00, 0x80, 0x03,
   0x07, 0x00, 0x78, 0x78, 0x1e, 0x1e, 0x3c, 0x78, 0x78, 0x00, 0x80, 0x03,
   0x07, 0x00, 0xf8, 0x7f, 0xfe, 0x1f, 0x3c, 0x78, 0x78, 0x00, 0x80, 0x03,
   0x07, 0x00, 0xf8, 0x7f, 0xfc, 0x0f, 0x3c, 0x78, 0x78, 0x00, 0x80, 0x03,
   0x07, 0x00, 0xf8, 0x3f, 0xf8, 0x07, 0x3c, 0x78, 0x78, 0x00, 0x80, 0x03,
   0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x03,
   0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x03,
   0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03,
   0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x01,
   0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x01,
   0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x00,
   0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x00,
   0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00,
   0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x00
};

static const unsigned char LEDStripModeRainbow[] U8X8_PROGMEM = {
   0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 0x00,
   0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00,
   0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,
   0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x00,
   0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x01,
   0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x01,
   0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03,
   0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x03,
   0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x03,
   0x07, 0xf8, 0x0f, 0xff, 0xe1, 0x7f, 0xf0, 0x87, 0xf7, 0x1e, 0x80, 0x03,
   0x07, 0xf8, 0x1f, 0xff, 0xe3, 0xff, 0xf8, 0x8f, 0xf7, 0x1e, 0x80, 0x03,
   0x07, 0xf8, 0x3f, 0xff, 0xe7, 0xff, 0xfc, 0x9f, 0xf7, 0x1e, 0x80, 0x03,
   0x07, 0x78, 0x3c, 0x8f, 0xe7, 0xe1, 0x3c, 0x9e, 0xf7, 0x1e, 0x80, 0x03,
   0x07, 0x78, 0x3c, 0x8f, 0xe7, 0xe1, 0x3c, 0x9e, 0xf7, 0x1e, 0x80, 0x03,
   0x07, 0x78, 0x3c, 0x8f, 0xe7, 0x7f, 0x3c, 0x9e, 0xf7, 0x1e, 0x80, 0x03,
   0x07, 0xf8, 0x3f, 0x8f, 0xe7, 0x7f, 0x3c, 0x9e, 0xf7, 0x1e, 0x80, 0x03,
   0x07, 0xf8, 0x1f, 0x8f, 0xe7, 0xe1, 0x3c, 0x9e, 0xf7, 0x1e, 0x80, 0x03,
   0x07, 0xf8, 0x0f, 0x8f, 0xe7, 0xe1, 0x3c, 0x9e, 0xf7, 0x1e, 0x80, 0x03,
   0x07, 0x78, 0x1e, 0x8f, 0xe7, 0xff, 0xfc, 0x9f, 0xff, 0x1f, 0x80, 0x03,
   0x07, 0x78, 0x1e, 0x8f, 0xe7, 0xff, 0xfc, 0x9f, 0xff, 0x0f, 0x80, 0x03,
   0x07, 0x78, 0x3c, 0x8f, 0xe7, 0x7f, 0xf8, 0x0f, 0xff, 0x07, 0x80, 0x03,
   0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x03,
   0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x03,
   0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x03,
   0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03,
   0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x01,
   0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x01,
   0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x00,
   0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x00,
   0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00,
   0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x00  
};

static const unsigned char LEDStripModeDemo[] U8X8_PROGMEM = { 
   0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 0x00,
   0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00,
   0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,
   0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x00,
   0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x01,
   0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xc0, 0x01,
   0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xc0, 0x03,
   0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0x81, 0x03,
   0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0x83, 0x03,
   0x87, 0xff, 0xc0, 0x3f, 0xff, 0x0f, 0xfc, 0x01, 0xfc, 0xff, 0x81, 0x03,
   0x87, 0xff, 0xe1, 0x3f, 0xff, 0x1f, 0xfe, 0x03, 0x3c, 0xf0, 0x80, 0x03,
   0x87, 0xff, 0xf3, 0x3f, 0xff, 0x3f, 0xff, 0x07, 0x3c, 0x60, 0x80, 0x03,
   0x87, 0xc7, 0xf3, 0x00, 0xef, 0x3d, 0x8f, 0x07, 0x3c, 0x20, 0x83, 0x03,
   0x87, 0xc7, 0xf3, 0x00, 0xef, 0x3d, 0x8f, 0x07, 0x3c, 0x80, 0x83, 0x03,
   0x87, 0xc7, 0xf3, 0x1f, 0xef, 0x3d, 0x8f, 0x07, 0x3c, 0x80, 0x83, 0x03,
   0x87, 0xc7, 0xf3, 0x1f, 0xef, 0x3d, 0x8f, 0x07, 0x3c, 0x80, 0x83, 0x03,
   0x87, 0xc7, 0xf3, 0x1f, 0xef, 0x3d, 0x8f, 0x07, 0x3c, 0x80, 0x83, 0x03,
   0x87, 0xc7, 0xf3, 0x00, 0xef, 0x3d, 0x8f, 0x07, 0x1c, 0x80, 0x83, 0x03,
   0x87, 0xff, 0xf3, 0x3f, 0xef, 0x3d, 0xff, 0x07, 0xcc, 0x80, 0x83, 0x03,
   0x87, 0xff, 0xf3, 0x3f, 0xef, 0x3d, 0xff, 0x07, 0xe0, 0x80, 0x83, 0x03,
   0x87, 0xff, 0xe1, 0x3f, 0xef, 0x3d, 0xfe, 0x03, 0xf0, 0xff, 0x83, 0x03,
   0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0x83, 0x03,
   0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0x81, 0x03,
   0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x7f, 0x80, 0x03,
   0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0xc0, 0x03,
   0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0xc0, 0x01,
   0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x01,
   0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x00,
   0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x00,
   0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00,
   0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x00 
   };

static const unsigned char LEDStripModeColourBounce[] U8X8_PROGMEM = {  
0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 0x00,
   0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00,
   0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,
   0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x00,
   0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x01,
   0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x01,
   0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03,
   0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x03,
   0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x03,
   0x07, 0xfc, 0xc3, 0x1f, 0x1e, 0xe0, 0x0f, 0x8f, 0xe7, 0x3f, 0x80, 0x03,
   0x07, 0xfe, 0xe3, 0x3f, 0x1e, 0xf0, 0x1f, 0x8f, 0xe7, 0x7f, 0x80, 0x03,
   0x07, 0xff, 0xf3, 0x7f, 0x1e, 0xf8, 0x3f, 0x8f, 0xe7, 0xff, 0x80, 0x03,
   0x07, 0x0f, 0xf0, 0x78, 0x1e, 0x78, 0x3c, 0x8f, 0xe7, 0xf1, 0x80, 0x03,
   0x07, 0x0f, 0xf0, 0x78, 0x1e, 0x78, 0x3c, 0x8f, 0xe7, 0xf1, 0x80, 0x03,
   0x07, 0x0f, 0xf0, 0x78, 0x1e, 0x78, 0x3c, 0x8f, 0xe7, 0xf1, 0x80, 0x03,
   0x07, 0x0f, 0xf0, 0x78, 0x1e, 0x78, 0x3c, 0x8f, 0xe7, 0xff, 0x80, 0x03,
   0x07, 0x0f, 0xf0, 0x78, 0x1e, 0x78, 0x3c, 0x8f, 0xe7, 0x7f, 0x80, 0x03,
   0x07, 0x0f, 0xf0, 0x78, 0x1e, 0x78, 0x3c, 0x8f, 0xe7, 0x3f, 0x80, 0x03,
   0x07, 0xff, 0xf3, 0x7f, 0xfe, 0xfb, 0x3f, 0xff, 0xe7, 0x79, 0x80, 0x03,
   0x07, 0xff, 0xf3, 0x7f, 0xfe, 0xfb, 0x3f, 0xff, 0xe7, 0x79, 0x80, 0x03,
   0x07, 0xfe, 0xe3, 0x3f, 0xfe, 0xf3, 0x1f, 0xfe, 0xe3, 0xf1, 0x80, 0x03,
   0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x03,
   0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x03,
   0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x03,
   0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03,
   0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x01,
   0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x01,
   0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x00,
   0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x00,
   0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00,
   0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x00
   };
   
static const unsigned char MsgSent[] U8X8_PROGMEM = { 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xfc, 0x00, 0x00, 0xfe, 0xf1, 0xcf, 0x7f, 0xfc, 0x07, 0xf8, 0x07, 0x00,
   0xff, 0xf9, 0xcf, 0xff, 0xfc, 0x07, 0xf0, 0x3f, 0x00, 0xff, 0xf9, 0xcf,
   0xff, 0xfc, 0xe7, 0xf1, 0xff, 0x00, 0x07, 0x78, 0xc0, 0xe3, 0xf0, 0x00,
   0xe0, 0xff, 0x07, 0xff, 0xf8, 0xc7, 0xe3, 0xf0, 0x00, 0xe0, 0xff, 0x3f,
   0xfe, 0xf9, 0xcf, 0xe3, 0xf0, 0x00, 0xcf, 0xff, 0x1f, 0xfc, 0xf9, 0xc7,
   0xe3, 0xf0, 0x00, 0xe0, 0xff, 0x07, 0xc0, 0x79, 0xc0, 0xe3, 0xf0, 0x00,
   0xe0, 0xff, 0x01, 0xfe, 0xf9, 0xcf, 0xe3, 0xf0, 0xc0, 0xf1, 0x7f, 0x00,
   0xff, 0xf9, 0xcf, 0xe3, 0xf0, 0xc0, 0xf0, 0x0f, 0x00, 0xff, 0xf0, 0xcf,
   0xe3, 0xf0, 0x00, 0xf8, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00
};



// Callback when data is sent
void OnDataSent(uint8_t *mac_addr, uint8_t sendStatus) {
  if (debug){Serial.print("Last Packet Send Status: ");}
  if (sendStatus == 0){
    if (debug){Serial.println("Delivery success");}
  }
  else{
    if (debug){Serial.println("Delivery fail");}
    //during ping, if it fails, assume power off and set graphics
    //LEDStripPwrState = 0;
    LEDStripModeState = 0;  //will show as powered off
    updateDispElements(abState, sbState, LEDStripModeState);
  }
}

//NOTE - using d1 and e1 for sending
  
// Callback when data is received
void OnDataRecv(uint8_t * mac, uint8_t *incomingData, uint8_t len) {
  memcpy(&myData, incomingData, sizeof(myData));
  //LEDStripPwrState = myData.a1;
  //selectedMode = myData.b1;
  LEDStripModeState = myData.c1;
  startupDispMode = myData.e1;
 
  if (debug){
    Serial.print("Bytes received: ");
    Serial.println(len);
    Serial.print("a1: ");
    Serial.println(myData.a1);
    Serial.print("b1 (displayMode):");
    Serial.println(myData.b1);
    Serial.print("c1 (LEDSTripModeState): ");
    Serial.println(myData.c1);
    Serial.print("d1: ");
    Serial.println(myData.d1);
    Serial.print("e1: ");
    Serial.println(myData.e1);
    Serial.println();
  }

}
//#######################################################################################################
  
void setup(void) 
{
  Serial.begin(115200);
  pinMode(mPlexReadPin, INPUT);
  pinMode(abSensorPin, OUTPUT);  //see function call for this. Issue with setting this to GPIO in setup.
  pinMode(seatSensorPin, OUTPUT);
  digitalWrite(abSensorPin, LOW);
  digitalWrite(seatSensorPin, LOW);

  upToggle.begin();              // initialize the button object

  // Set device as a Wi-Fi Station - ESP-NOW
  WiFi.mode(WIFI_STA);
  
  // Init ESP-NOW
  if (esp_now_init() != 0) {
     if (debug){Serial.println("Error initializing ESP-NOW");}
    return;
  }
  esp_now_set_self_role(ESP_NOW_ROLE_COMBO);

  // Once ESPNow is successfully Init, we will register for Send CB to
  // get the status of Trasnmitted packet
  esp_now_register_send_cb(OnDataSent);
  
  // Register peer
  esp_now_add_peer(broadcastAddress, ESP_NOW_ROLE_COMBO, 1, NULL, 0);   
  // Register for a callback function that will be called when data is received
  esp_now_register_recv_cb(OnDataRecv);


  u8g2.begin();
  delay(100);
  u8g2.setContrast(75);

  //delay(2000);
  doIntro();
  delay(3000);
}
//#######################################################################################################

void loop(void) 
{
  
   if ((millis() - lastPingTime) > timerDelay) {
    sendPing();
    readAlerts();
    lastPingTime = millis();
  }
 
  //if (debug){Serial.print("B1:");Serial.print(upToggle.read());}
  //if (debug){Serial.print("  B2:");Serial.println(dnToggle.read());}
  //if (debug){Serial.print("  SelectedMode:");Serial.println(selectedMode);}
  
  //refresh the display
  if ((millis() - lastTime) > timerDelay) {
    u8g2.clearBuffer();
    updateDispElements(abState, sbState, LEDStripModeState);
    if ((startupDispMode !=-1) && (!wasDoneOnce))
    {
      selectedMode = startupDispMode;
      wasDoneOnce = true;
    }
    if (LEDStripModeState != 0)   //only show modes if the strip is powered up
    {
      showMode(selectedMode);  
    }
    
    u8g2.sendBuffer();
    lastTime = millis();
    if (debug){Serial.println("Updated display...");}
  }

  
  upToggle.read();
  if (upToggle.wasReleased())
  {
    if (!btnHold)
    {
      doLEDStripModeChange(selectedMode);
      if (debug){Serial.println(">>>>>>>>>>>>>>>>>>>button release triggered..");}
      //sendData();
    }
    btnHold = false;
  } 
  else if (upToggle.pressedFor(1000))
  {
    btnHold = true;
    u8g2.drawXBMP(135, 48, 70, 17, MsgSent);
    u8g2.sendBuffer();
    delay(1000);
    doSeq = 1;
    sendData();
    doSeq = 0; 
  }
 delay(20); 
}
//#######################################################################################################

void readAlerts()
{
  //int A0Raw;
  

  //Issue with using D6, so ran out of pins and had to use TX as a GPIO
  //Also found issu with setting this in Setup caused failure of comms between 2 ESPs.  Setting here instead.
  //THIS DISABLES ABILITY TO VIEW SERIAL DEBUNGGING INFO.
  //pinMode(abSensorPin, FUNCTION_3); //set GPIO 1 (TX) abSensorPin to a GPIO  https://arduino.stackexchange.com/questions/29938/how-to-i-make-the-tx-and-rx-pins-on-an-esp-8266-01-into-gpio-pins

  //now turn each LDR on/off rapidly while taking a reading of the analog pin in between cycles.
  digitalWrite(abSensorPin, HIGH);
  delay(20);
  //A0Raw = analogRead(mPlexReadPin);
  if (debug){Serial.print("AirBag: "); Serial.print(analogRead(mPlexReadPin));}
  if (analogRead(mPlexReadPin) > 700) {abState = 1;} else {abState = 0;}
  digitalWrite(abSensorPin, LOW);
  delay(20);
  
  digitalWrite(seatSensorPin, HIGH);
  delay(20);
  //A0Raw = analogRead(mPlexReadPin);
  if (debug){Serial.print("  Seat: "); Serial.println(analogRead(mPlexReadPin));}
  if (analogRead(mPlexReadPin) > 700) {sbState = 1;} else {sbState = 0;}
  digitalWrite(seatSensorPin, LOW);
  delay(20);
  //pinMode(abSensorPin, FUNCTION_0); //set back to TX so it doesnt interfere with ESP-NOW
}
//#######################################################################################################

void doIntro()
{
    u8g2.clearBuffer();
    for (int i=-256; i<=6; i+=10) 
    {
      u8g2.clearBuffer();
      u8g2.drawXBMP(i, 2, 256, 56, miataLogoLG);
      u8g2.sendBuffer();
    }
   delay(100);
   /*
   for (int i=5; i<=260; i+=5) 
   {
     //drawPixel(u8g2_uint_t x, u8g2_uint_t y)
     //u8g2.drawPixel(random(1,256), random(55,60));
     u8g2.drawLine(i, 61, i, 61);
     u8g2.drawLine(i, 64, i, 64);
     u8g2.sendBuffer();
     yield();
   }
   */
   
}
//#######################################################################################################

void updateDispElements(int abSt, int stbltSt, int stripModeState)
{
  if (stbltSt==1)
  {
    u8g2.drawXBMP(223, 2, 30, 30, seatbeltWarning);  
  }
  if (abSt==1) 
  {
    u8g2.drawXBMP(223, 32, 30, 30, airbag);
  }

  switch (stripModeState) {
    case 0:
      u8g2.drawXBMP(4, 10, 106, 45, LEDStripOff);  
      break;
    case 1:
      u8g2.drawXBMP(4, 10, 106, 45, LEDStripOn);
      break;
    case 2:
      u8g2.drawXBMP(4, 10, 106, 45, LEDStripActive);
      break;
    case 3:
      u8g2.drawXBMP(4, 10, 106, 45, LEDStripBraking);
      break;

    default:
      u8g2.drawXBMP(4, 10, 106, 45, LEDStripOff); 
      break;
  }    
}
//#######################################################################################################

void showMode(int m)
{
  switch (m) 
  {
    case 1:  
      u8g2.drawXBMP(125, 18, 90, 31, LEDStripModeKITT);
      break;
    case 2:        
      u8g2.drawXBMP(125, 18, 90, 31, LEDStripModeBounce);
      break;
    case 3:
      u8g2.drawXBMP(125, 18, 90, 31, LEDStripModeBoth);
      break;
    case 4:
      u8g2.drawXBMP(125, 18, 90, 31, LEDStripModeColourBounce);
      break;
    case 5:
      u8g2.drawXBMP(125, 18, 90, 31, LEDStripModeRainbow);
      break;
    case 6:
      u8g2.drawXBMP(125, 18, 90, 31, LEDStripModeDemo);
      break;
    //default:
      //dont show anything
      //break;
  }
}
//#######################################################################################################

void doLEDStripModeChange(int m)
{
  
  //As toggle button is triggered, scroll through menu choices
  switch (m) 
  {
    case 1:
      //Scroll to next...
      for (int i=18; i>=-32; i-=4) 
      {
        if (i<8){i-=6;}
        u8g2.clearBuffer();
        u8g2.drawXBMP(125, i, 90, 31, LEDStripModeKITT);          //scroll this off view
        u8g2.drawXBMP(125, i+48, 90, 31, LEDStripModeBounce);     //scroll this into view
        updateDispElements(abState, sbState, LEDStripModeState);
        u8g2.sendBuffer();
        lastTime = millis();
      }
      selectedMode = 2;  
      break;

    case 2:
      //Scroll to next...
      for (int i=18; i>=-32; i-=4) 
      {
        if (i<8){i-=6;}
        u8g2.clearBuffer();
        u8g2.drawXBMP(125, i, 90, 31, LEDStripModeBounce);    //scroll this off view
        u8g2.drawXBMP(125, i+48, 90, 31, LEDStripModeBoth);   //scroll this into view
        updateDispElements(abState, sbState, LEDStripModeState);
        u8g2.sendBuffer();
        lastTime = millis();
      }
      selectedMode = 3;
      break;

    case 3:
      //Scroll to next...
      for (int i=18; i>=-32; i-=4) 
      {
        if (i<8){i-=6;}
        u8g2.clearBuffer();
        u8g2.drawXBMP(125, i, 90, 31, LEDStripModeBoth);             //scroll this off view
        u8g2.drawXBMP(125, i+48, 90, 31, LEDStripModeColourBounce);  //scroll this into view
        updateDispElements(abState, sbState, LEDStripModeState);
        u8g2.sendBuffer();
        lastTime = millis();
      }    
      selectedMode = 4;
      break;

    case 4:
      //Scroll to next...
      for (int i=18; i>=-32; i-=4) 
      {
        if (i<8){i-=6;}
        u8g2.clearBuffer();
        u8g2.drawXBMP(125, i, 90, 31, LEDStripModeColourBounce);    //scroll this off view
        u8g2.drawXBMP(125, i+48, 90, 31, LEDStripModeRainbow);      //scroll this into view
        updateDispElements(abState, sbState, LEDStripModeState);
        u8g2.sendBuffer();
        lastTime = millis();
      }    
      selectedMode = 5;
      break;

    case 5:
      //Scroll to next...
      for (int i=18; i>=-32; i-=4) 
      {
        if (i<8){i-=6;}
        u8g2.clearBuffer();
        u8g2.drawXBMP(125, i, 90, 31, LEDStripModeRainbow);        //scroll this off view
        u8g2.drawXBMP(125, i+48, 90, 31,LEDStripModeDemo);         //scroll this into view
        updateDispElements(abState, sbState, LEDStripModeState);
        u8g2.sendBuffer();
        lastTime = millis();
      }    
      selectedMode = 6;
      break;

      
    case 6:
      //Scroll to next...
      for (int i=18; i>=-32; i-=4) 
      {
        if (i<8){i-=6;}
        u8g2.clearBuffer();
        u8g2.drawXBMP(125, i, 90, 31, LEDStripModeDemo);        //scroll this off view
        u8g2.drawXBMP(125, i+48, 90, 31, LEDStripModeKITT);     //scroll this into view
        updateDispElements(abState, sbState, LEDStripModeState);
        u8g2.sendBuffer();
        lastTime = millis();
      }    
      selectedMode = 1;
      break;

      
      default:
      selectedMode = 1;
      break;
  }    
}
//#######################################################################################################

void sendData()
{
  myData.a1 = 0;  //not used
  myData.b1 = 0;  //not used
  myData.c1 = 0;  //not used
  myData.d1 = doSeq;
  myData.e1 = selectedMode;
  esp_now_send(broadcastAddress, (uint8_t *) &myData, sizeof(myData));
}
//#######################################################################################################

void sendPing()
{
  esp_now_send(broadcastAddress, (uint8_t *) &dummyData, sizeof(dummyData));
}
