
//!!!!!!! Something is not right with the SAMD boards for SEEED 1.8.2. Rolled back to 1.8.1 and it compiles.  Log sent to SEEED.

//References and credits:
//Libraries
//Follow the Wiki to install the SEEED WIO SAMD boards
//https://wiki.seeedstudio.com/Wio-Terminal-Getting-Started/
//https://github.com/lovyan03/LovyanGFX
//https://github.com/embeddedlab786/Countdown_Timer
//https://www.avdweb.nl/arduino/hardware-interfacing/arduino-switch-button-library-with-short-long-press-double-click-and-beep

//https://fonts.google.com/specimen/Orbitron#standard-styles orbitron font
//Used to convet font to GFX fonts:  https://rop.nl/truetype2gfx/
//https://create.arduino.cc/projecthub/embeddedlab786/countdown-timer-relay-1e5b39?ref=search&ref_id=countdown%20timer&offset=2
//https://learn.adafruit.com/adafruit-gfx-graphics-library/loading-images
//https://www.instructables.com/How-to-use-DHT-22-sensor-Arduino-Tutorial/
// DHT Sample:  https://www.instructables.com/How-to-use-DHT-22-sensor-Arduino-Tutorial/


//I M P O R T A N T - you will need to modify the LovyanGFX code per below as I've added some custom fonts. I've added more than 
//used here for future projects, so just add what's needed here.  //see lgfx_fonts.cpp and lgfx_fonts.hpp for adding new fonts
//Steps:
// 1) You can use the link above to get more Google fonts. 
// 2) Open lgfx_fonts.cpp and add the below lines around line 1130:
//  // Custom fonts
//  #include "../Fonts/Custom/Orbitron_ExtraBold9pt7b.h"  //DJA
//  #include "../Fonts/Custom/Orbitron_ExtraBold12pt7b.h"  //DJA
//  #include "../Fonts/Custom/Orbitron_ExtraBold16pt7b.h"  //DJA
//  #include "../Fonts/Custom/Orbitron_ExtraBold18pt7b.h"  //DJA
//  #include "../Fonts/Custom/Orbitron_ExtraBold24pt7b.h"  //DJA
//  #include "../Fonts/Custom/Orbitron_ExtraBold40pt7b.h"  //DJA
//  #include "../Fonts/Custom/Orbitron_ExtraBold48pt7b.h"  //DJA

// 3) Open lgfx_fonts.hpp and add the below code around line 323:
//  extern const lgfx::GFXfont Orbitron_ExtraBold9pt7b;  //DJA
//  extern const lgfx::GFXfont Orbitron_ExtraBold12pt7b;  //DJA
//  extern const lgfx::GFXfont Orbitron_ExtraBold16pt7b;  //DJA
//  extern const lgfx::GFXfont Orbitron_ExtraBold18pt7b;  //DJA
//  extern const lgfx::GFXfont Orbitron_ExtraBold24pt7b;  //DJA
//  extern const lgfx::GFXfont Orbitron_ExtraBold40pt7b;  //DJA
//  extern const lgfx::GFXfont Orbitron_ExtraBold48pt7b;  //DJA
//
//  4) Move the fonts included in the download to the /Fonts/Custom folder.  Then save and compile.
//

// V E R S I O N   H I S T O R Y 
//v8 - shifted some stuff around and added histogram
//v7 - added joystick control
//v6 - switched over to WIO Termimal hardware + LovyanGFX graphics library
//v5 - added simple timer library to poll DHT more slowly.
//v4 - adding DHT22 sensor
//v3 - getting timer working etc
//v2 - adding countdown clock.
//#######################################################################################################

//ORDER Must be in this order or will fail to compile. Not sure why...
#define LGFX_WIO_TERMINAL          // Seeed Wio Terminal
#define LGFX_USE_V1                // Seeed Wio Terminal
#include <LovyanGFX.hpp>
#include <LGFX_AUTODETECT.hpp>
//end ORDER

#include <SimpleTimer.h>
#include <DHT.h>
#include "Countimer.h"
#include "avdweb_Switch.h" 


static LGFX tft;                 // LGFX
static LGFX_Sprite sprite(&tft);

#define UVLEDPin  D4
#define DHTPIN D3     // what pin we're connected to
#define DHTTYPE DHT22   // DHT 22  (AM2302)

#define debug true


int time_s = 0;
int time_sL = 0;
int time_m = 15;
int time_mL = 0;
int time_h = 0;
int set = 0;
int xShift = 6;
//int flag1=0, flag2=0;
//int relay = 8;
int buzzer = A0;
boolean countStart = false;
boolean countStop = false;
boolean doTimerBoxOnce = false;

int chk;
float hum;  //Stores humidity value
float temp; //Stores temperature value

int histogramXShift = 0;

 //like this font:  &fonts::Orbitron_Light_24 
  //&fonts::Font7      
  //lcd.setColor(0xFFFF00U); white

#define CLR_PURPLE             0xFF00FFU
#define CLR_RED                0xFF0000U
#define CLR_GREEN              0x00FF00U
#define CLR_BLUE               0x0000FFU
#define CLR_YELLOW             0xFFFF00U
#define CLR_CYAN               0x00FFFFU
#define CLR_PURPLE             0xFF00FFU
#define CLR_WHITE              0xFFFFFFU
#define CLR_BLACK              0x000000U
#define CLR_ORANGE              0xFF7F00U

Countimer tdown;
DHT dht(DHTPIN, DHTTYPE);           // Initialize DHT sensor for normal 16mhz Arduino
SimpleTimer timer;                  // Init the simple timer object

 #define UP WIO_5S_UP
 #define DN WIO_5S_DOWN
 #define LF WIO_5S_LEFT
 #define RT WIO_5S_RIGHT
 #define PR WIO_5S_PRESS

Switch upButton = Switch(WIO_5S_UP, INPUT_PULLUP, HIGH, 1); 
Switch dnButton = Switch(WIO_5S_DOWN, INPUT_PULLUP, HIGH, 1);
Switch lfButton = Switch(WIO_5S_LEFT, INPUT_PULLUP, HIGH, 1);
Switch rtButton = Switch(WIO_5S_RIGHT, INPUT_PULLUP, HIGH, 1);
Switch prButton = Switch(WIO_5S_PRESS, INPUT_PULLUP, HIGH, 1);




//#######################################################################################################
void setup(void) {
  Serial.begin (115200);
  pinMode(UVLEDPin, OUTPUT);
  pinMode(WIO_BUZZER, OUTPUT);

  //pinMode(WIO_5S_UP, INPUT_PULLUP);
  //pinMode(WIO_5S_DOWN, INPUT_PULLUP);
  //pinMode(WIO_5S_LEFT, INPUT_PULLUP);
  //pinMode(WIO_5S_RIGHT, INPUT_PULLUP);
  //pinMode(WIO_5S_PRESS, INPUT_PULLUP);
 

  timer.setInterval(2000, showHumTemp);    //run doHumTmp every second for temp


  dht.begin();

  tdown.setInterval(print_time, 999);
  
  tft.init();
  tft.setRotation(1);
  tft.setBrightness(128);
  //tft.setColorDepth(16);  // RGB565
  tft.setColorDepth(24);  // RGB888

  
  //tft.setFont(&FreeSansBold24pt7b);
  //tft.setFont(&fonts::FreeSansBold24pt7b);
  //tft.setFont(&fonts::Orbitron_Light_24);
  
  tft.fillScreen(CLR_BLACK); 
   
  if (debug) {Serial.println(F("TFT Initialized"));}

  
  showStatWaiting();
  
  //doBuzzer();
  
  /*
  for (int i=0; i<2; i++)
  {
  showStatWaiting();
  delay(1000);
  showStatCuring();
  delay(1000);
  showStatComplete();
  delay(1000);
  }
  */
  tft.drawRoundRect(2, 165, 316, 50, 6, CLR_WHITE); //draw temp hum box
}

void doBuzzer()
{
   for(int i=0; i<6; i++)
   {
     analogWrite(WIO_BUZZER, 128);
     delay(600);
     analogWrite(WIO_BUZZER, 0);
     delay(400);
   }
}

//#######################################################################################################
void showStatWaiting()
{
  tft.drawRoundRect(2, 110, 316, 50, 6, CLR_GREEN); //draw status box
  tft.fillRect(7, 112, 306, 45, CLR_BLACK); //nt16_t x, int16_t y, int16_t w, int16_t h, uint16_t color
  //tft.setFont(&FreeSansBold9pt7b);
  //tft.setTextFont(1);
  //tft.setFont(&fonts::FreeSansBold9pt7b);
  tft.setFont(&fonts::Orbitron_Light_24);
  tft.setCursor(32,120);
  //tft.setTextColor(ST77XX_GREEN);  
  tft.setTextColor(CLR_GREEN);
  tft.print("READY TO START");
  //tft.setFont(&FreeSansBold24pt7b);  //set font back to large 
  //tft.setTextFont(4);
  //tft.setFont(&fonts::FreeSansBold24pt7b);
}

//#######################################################################################################
void showStatCuring()
{
  tft.drawRoundRect(2, 110, 316, 50, 6, CLR_RED); //draw status box
  tft.fillRect(7, 112, 306, 45, CLR_BLACK); //nt16_t x, int16_t y, int16_t w, int16_t h, uint16_t colortft.fillRect(2, 55, 312, 30, CLR_PURPLE); //nt16_t x, int16_t y, int16_t w, int16_t h, uint16_t color  
  //tft.setTextFont(2);
  //tft.setFont(&FreeSansBold9pt7b);
  //tft.setFont(&fonts::FreeSansBold9pt7b);
  tft.setFont(&fonts::Orbitron_Light_24);
  tft.setCursor(65,120);
  //tft.setTextColor(ST77XX_RED);
  tft.setTextColor(CLR_RED);  
  tft.print("!  C U R I N G  !");
  //tft.setFont(&FreeSansBold24pt7b);  //set font back to large  
  //tft.setTextFont(4);
  //tft.setFont(&fonts::FreeSansBold24pt7b);
}

//#######################################################################################################
void showStatComplete()
{
  tft.drawRoundRect(2, 110, 316, 50, 6, CLR_GREEN); //draw status box  
  tft.fillRect(7, 112, 306, 45, CLR_BLACK); //nt16_t x, int16_t y, int16_t w, int16_t h, uint16_t color
  //tft.setFont(&FreeSansBold9pt7b);
  //tft.setTextFont(2);
  //tft.setFont(&fonts::FreeSansBold9pt7b);
  tft.setFont(&fonts::Orbitron_Light_24);
  tft.setCursor(50,120);
  //tft.setTextColor(ST77XX_GREEN);  
  tft.setTextColor(CLR_GREEN);
  tft.print("C O M P L E T E");
  //tft.setFont(&FreeSansBold24pt7b);  //set font back to large 
  //tft.setTextFont(4);
  //tft.setFont(&fonts::FreeSansBold24pt7b);
}

//#######################################################################################################
void showStatPaused()
{
  tft.drawRoundRect(2, 110, 316, 50, 6, CLR_ORANGE); //draw status box  
  tft.fillRect(7, 112, 306, 45, CLR_BLACK); //nt16_t x, int16_t y, int16_t w, int16_t h, uint16_t color
  tft.setFont(&fonts::Orbitron_Light_24);
  tft.setCursor(80,120);
  tft.setTextColor(CLR_ORANGE);
  tft.print("P A U S E D");
}

//#######################################################################################################

void showHumTemp()
{
  hum = dht.readHumidity();
  temp = dht.readTemperature();
 
  //Print temp and humidity values to serial monitor
  if (debug) {Serial.print("Humidity: ");}
  if (debug) {Serial.print(hum);}
  if (debug) {Serial.print("%, Temp: ");}
  if (debug) {Serial.print(temp);}
  if (debug) {Serial.println(" Celsius");}
  
  tft.fillRect(7, 168, 308, 40, CLR_BLACK); //nt16_t x, int16_t y, int16_t w, int16_t h, uint16_t color  
   
  //tft.setTextFont(2);
  //tft.setFont(&FreeSansBold9pt7b);
  //tft.setFont(&fonts::FreeSansBold9pt7b);
  //tft.setFont(&fonts::Orbitron_Light_24);
  tft.setFont(&fonts::Orbitron_Light_24);
  //tft.setFont(&fonts::Orbitron_ExtraBold16pt7b);
  
  tft.setCursor(30,175);
  tft.setTextColor(CLR_WHITE);
  tft.print(temp);
  //tft.print( "°C");
  tft.print("  C   ");
  tft.print(hum);
  tft.print(" %");

 
  //do degree
  tft.setFont(&FreeMono9pt7b);
  //tft.setFont(&fonts::FreeSansBold9pt7b);
  //tft.setFont(&fonts::Orbitron_Light_24);
  //tft.setFont(&fonts::Orbitron_ExtraBold16pt7b);
  tft.setCursor(110,176);
  tft.print("o");
  //end do degree
  //tft.setFont(&FreeSansBold24pt7b);  //set font back to large   
  //tft.setTextFont(4);
  //tft.setFont(&fonts::FreeSansBold24pt7b);
  
  if (debug) {Serial.print("Histogram Count: ");}
  if (debug) {Serial.println(histogramXShift);}
  doHistogram(temp);
  // doHistogram(random(10,80)); testing
  
  
}
//#######################################################################################################

void doHistogram(int temp)
{
  
  //fillRoundRect ( x, y, w, h, r, color);  
  //fillRect      ( x, y, w, h   , color); 
  //drawPixel     ( x, y         , color); 
  int tmpMapped = map(temp, 10, 80, 0, 25);
  
   if ((tmpMapped > 2) && (tmpMapped <= 10))
     {
       tft.fillRect(histogramXShift*4, 240-tmpMapped, 2, tmpMapped, CLR_GREEN);
     }
     else if ((tmpMapped > 10) && (tmpMapped <= 15))
     {
       tft.fillRect(histogramXShift*4, 240-tmpMapped, 2, tmpMapped, CLR_BLUE);
     }
     else if ((tmpMapped > 15) && (tmpMapped <= 25))
     {
       tft.fillRect(histogramXShift*4, 240-tmpMapped, 2, tmpMapped, CLR_RED);
     }
   histogramXShift++;

   if (histogramXShift > 76) 
   {
     tft.fillRect(0, 216, 320, 30, CLR_BLACK); //x,y, w, h, color  
     histogramXShift = 0;
   }
   
     
  
    
}

  
//#######################################################################################################
void print_time()
{
  time_s = time_s-1;
  if(time_s<0){time_s=59; time_m = time_m-1;}
  if(time_m<0){time_m=59; time_h = time_h-1;}
}

void tdownComplete(){if (debug) {Serial.print("ok");}}




//#######################################################################################################
void loop()
{
  tdown.run();
  timer.run();
  showClock();

  
  
  upButton.poll();
  dnButton.poll();
  lfButton.poll();
  rtButton.poll();
  prButton.poll();
  if(upButton.pushed()) {if (debug) {Serial.print("upButton pushed ");}}
  if(dnButton.pushed()) {if (debug) {Serial.print("downButton pushed ");}}
  if(lfButton.pushed()) {if (debug) {Serial.print("leftButton pushed ");}}
  if(rtButton.pushed()) {if (debug) {Serial.print("rightButton pushed ");}}
  if(prButton.pushed()) {if (debug) {Serial.print("prButton pushed ");}}
  if(prButton.longPress()) {if (debug) {Serial.println("prButton longPress");}} 
  
  /*
  if (digitalRead(WIO_5S_UP) == LOW) {
    Serial.println("5 Way Up");
   }
   else if (digitalRead(WIO_5S_DOWN) == LOW) {
    Serial.println("5 Way Down");
   }
   else if (digitalRead(WIO_5S_LEFT) == LOW) {
    Serial.println("5 Way Left");
   }
   else if (digitalRead(WIO_5S_RIGHT) == LOW) {
    Serial.println("5 Way Right");
   }
   else if (digitalRead(WIO_5S_PRESS) == LOW) {
    Serial.println("5 Way Press");
   }
   */
  
  if (upButton.pushed())
  {
     time_m++;
     if (debug) {Serial.println("Adding a minute...");}
     if(time_m>59){time_m=0;}  
  }
  if (dnButton.pushed())
  {
     time_m--;
     if (debug) {Serial.println("Removing a minute...");}
     if(time_m<0){time_m=59;}  
  }
  
  
  if ((prButton.pushed()) && (!countStart))
  //if ((true) && (!countStart))
  {
    if (debug) {Serial.println(">>>>>>>>>>>>>>>   Button was pushed...");}
    showStatCuring();
    digitalWrite(UVLEDPin, HIGH); 
    tdown.restart(); 
    tdown.start();
    countStart = true;
    countStop = false;
  } 
  else if ((prButton.pushed()) && (!countStop))
  {
    showStatPaused();
    tdown.stop();
    digitalWrite(UVLEDPin, LOW);
    countStop = true;
    countStart = false;
  }
  
 
  
  //else if (upToggle.pressedFor(3000))
  //{
  //  if (debug) {Serial.println("Button was held pushed...");}
  //}
  


  //else if (upToggle.pressedFor(3000))
  //{
  //  if (debug) {Serial.println("Button was held pushed...");}

  //   time_m++;
  //    if (debug) {Serial.println("Adding a minute...");}
      //if(time_m>59){time_m=0;time_h++;}
 
  //if (countStart)
  //{
  //if(digitalRead (bt_start) == 0)
  //{ 
  //  if (debug) {Serial.print("btn_start clicked / HIGH");}
    //digitalWrite(relay, HIGH); 
  //  tdown.restart(); 
  //  tdown.start();
  //  countStart = false;
  //}
  
  //}
 //delay(20); 

 

  /*
  tft.setTextSize(txtSize);
  tft.setCursor(xLoc, yLoc);
  tft.setTextColor(ST7735_BLACK); 
  tft.print(lastV);
  tft.setTextColor(color);
  tft.setCursor(xLoc, yLoc);
  tft.print(newV);
  */

  if(time_s==0 && time_m==0 && time_h==0)
  {
    //flag2=0;
    tdown.stop(); 
    showStatComplete();
    doBuzzer();
    //for later use this to send Blynk notification
    digitalWrite(UVLEDPin, LOW);
    digitalWrite(buzzer, HIGH);
    delay(300);
    digitalWrite(buzzer, LOW);
    delay(200);
    digitalWrite(buzzer, HIGH);
    delay(300);
    digitalWrite(buzzer, LOW);
    delay(200);
    digitalWrite(buzzer, HIGH);
    delay(300);
    digitalWrite(buzzer, LOW);
    
  }

  //if(flag2==1){digitalWrite(relay, HIGH);}
  //else{digitalWrite(UVLEDPin, LOW);}

  delay(1);
   
}
//########################################################################

void showClock()
{

  //tft.setTextColor(ST7735_BLUE);
  //tft.setCursor(1,30);
  
    //if(time_h<=9){tft.print("0");}
    //tft.print(time_h);
    //tft.print(":");

  tft.setFont(&fonts::Orbitron_ExtraBold48pt7b);

    //Print initial 15:00 timer
  if (!doTimerBoxOnce)
  {
    //tft.setFont(&fonts::Orbitron_ExtraBold48pt7b);
    tft.drawRoundRect(2, 5, 316, 100, 6, CLR_BLUE);   //draw timer box
    tft.setTextColor(CLR_YELLOW);
    tft.setCursor(5 +xShift,12);
    tft.print("15");
    tft.setCursor(122 +xShift,8);
    tft.print(":");
    tft.setCursor(150 +xShift,12);
    tft.print("00");
    doTimerBoxOnce = true; //dont do again unless reboot
  }

  // DO MINUTES
  if (time_m != time_mL)
  {
    tft.fillRect(2 +xShift, 10, 120, 92, CLR_BLACK); //only blank out the minutes digits  //nt16_t x, int16_t y, int16_t w, int16_t h, uint16_t color    
    tft.setTextColor(CLR_YELLOW);
    tft.setCursor(5 +xShift,12);
    if(time_m<=9)           //handle when minutes are < 10 - shift cursor over
    {
      tft.setCursor(37 +xShift,12); //need to shift the 2nd digit over beside the 0
    }
    tft.print(time_m);
    time_mL = time_m;
  }

  // DO SECONDS
  if (time_s != time_sL)
  {
    //tft.setTextColor(ST77XX_YELLOW, ST77XX_BLACK);
    //tft.setCursor(65,38);
    //tft.print(":");

    tft.fillRect(150 +xShift, 10, 157, 92, CLR_BLACK);  //nt16_t x, int16_t y, int16_t w, int16_t h, uint16_t color
    //tft.setCursor(80 +xShift,150);
    tft.setTextColor(CLR_YELLOW);
    tft.setCursor(155 +xShift,12);   //set cursor for start of seconds digit
    if(time_s<=9)           //handle when seconds are < 10 - shift cursor over
    {
      tft.print("0");
      tft.setCursor(230 +xShift,12); //need to shift the 2nd digit over beside the 0
    }
    tft.print(time_s);
    time_sL = time_s;
  }    
}
//#######################################################################################################
