//Reference and Credit:
// KasaSmartPlug:        https://github.com/kj831ca/KasaSmartPlug/tree/main
// SimpleTimer:          https://github.com/jfturcot/SimpleTimer
// Sleep:                https://forum.seeedstudio.com/t/xiao-esp32s3-deep-sleep-current/267058
// Sleep                 https://forum.seeedstudio.com/t/external-wakeup-from-deep-sleep-on-xiao-esp32c/267532/4
  
#include <Arduino.h>
#include <WiFi.h>
#include "KasaSmartPlug.h"
//#include <SimpleTimer.h>

//****************************************************************************************
#define debug false // true to turn debugging on
//****************************************************************************************
//#define   buttonPin    GPIO_NUM_3
#define   buttonPin    D1

#define   LEDPin       D8
//#define   PIRPin       D5
int buttonState = 0;  // variable for reading the pushbutton status

const char *ssid = "SSID";
const char *password = "PWD"; 
String remoteBtnIP = "192.168.XXX.XXX";      //Button IP
char remoteBtnName[] = "NameOfSwitchInKasa";   //System uses this to connect to switch. Name must match what is set in the Kasa App

IPAddress ESP32_ip (192, 168, XXX, XXX);  //IP of ESP unit -can probably use remoteBtnIP
IPAddress dns_ip     (8, 8, 8, 8);
IPAddress gateway_ip (192, 168, XXX, XXX);
IPAddress subnet_mask(255, 255, 255, 0);
const byte bssid[] = {0xXX, 0xXX, 0xXX, 0xXX, 0xXX, 0xXX};  //MAC address of router -change to your router


KASAUtil kasaUtil;
//SimpleTimer timer;                     // the timer object


void scanDevices();
void flipDevicePowerState();
void goToSleep();
void testReadButton();

void setup()
{
  //esp_deep_sleep_disable_rom_logging(); // suppress boot messages
  pinMode(buttonPin,  INPUT); 
  //pinMode(PIRPin,  INPUT); 
  pinMode(LEDPin,  OUTPUT);
  if (debug) {Serial.begin(115200);}
  digitalWrite(LEDPin, HIGH);
 
  if (debug) {delay(3000);}
  // connect to 
  //WiFi.persistent(true);
  //WiFi.enableSTA(true);
  //WiFi.mode(WIFI_STA);      //already in this mode by default
  //WiFi.setAutoConnect(1);
  //WiFi.setAutoReconnect(true);
  //WiFi.persistent(true);
  
  //WiFi.disconnect(true);
  //WiFi.persistent(false);
  //WiFi.setTxPower(WIFI_POWER_8_5dBm);
  //WiFi.useStaticBuffers(true);
  WiFi.setHostname("ESPButton");    

  if (debug) {Serial.printf("Connecting to %s ", ssid);}
  WiFi.config(ESP32_ip, gateway_ip, subnet_mask, dns_ip);
  WiFi.begin(ssid, password, 11, bssid);
  //WiFi.begin(ssid, password);
  
  //WiFi.begin (char,pwd,channel,bssid, connect)
  while (WiFi.status() != WL_CONNECTED)
  {
    //delay(500);
    //if (debug) {Serial.print(".");}
    digitalWrite(LEDPin, HIGH);
    delay(20);
    digitalWrite(LEDPin, LOW);
    delay(20);
  }
  if (debug) {Serial.println("CONNNECTED");}
  digitalWrite(LEDPin, HIGH);

  if (debug) {Serial.println("[+] BSSID : " + WiFi.BSSIDstr());}
  if (debug) {Serial.print("[+] ESP32 IP : ");Serial.println(WiFi.localIP());}
  if (debug) {Serial.print("[+] ESP32 MAC : ");Serial.println(WiFi.macAddress());}
  
 
  //tmrSleep = timer.setTimeout(sleepDelayMs, goToSleep);
  
  flipDevicePowerState();
  if (debug) {Serial.printf("\r\nGoing to sleep in 5 seconds...");}
  delay(5000);  //wait a bit in case updating code 
  
  goToSleep();
  
}

void loop()
{
  //scanDevices();
  //testReadButton();
  //timer.run();  
}

void flipDevicePowerState()
{  
  //Note- for a specific device by IP change this in KasaSmartPlug.hpp:  int ScanDevices(int timeoutMs = 1000, String ipAddress  = "192.168.2.71"); 
  int found = kasaUtil.ScanDevices(500, remoteBtnIP);  //<< this is what's causing it to take a long time, but decreasing the # makes it miss the device

  bool plugstatus = 0;
  KASASmartPlug *kasaSwitch = kasaUtil.GetSmartPlug(remoteBtnName);
 
 
  if (kasaSwitch != NULL)
  {
    //kasaSwitch->QueryInfo();  //have to do this to get state from plug
    //plugstatus = kasaSwitch->state;
    if (debug) {Serial.printf("\r\nStatus before starting is: %d",kasaSwitch->state);}
    if (debug) {Serial.printf("\r\nFlip the plug state!");}
    kasaSwitch->SetRelayState(!kasaSwitch->state);  //if on swich off, vise-versa
    //kasaSwitch->QueryInfo();
    //if (debug) {Serial.printf("\r\nStatus after flipped is: %d",kasaSwitch->state);}
    //if (debug) {Serial.printf("\r\n State of sw after ON is: %d",kasaSwitch->state);}
    //vTaskDelay(2000 / portTICK_PERIOD_MS);
    //if (debug) {Serial.printf("\r\nTurn Off the plug");}
    //kasaSwitch->SetRelayState(0);
    //kasaSwitch->QueryInfo();
    //if (debug) {Serial.printf("\r\n State of sw after OFF is: %d",kasaSwitch->state);}

    //timer.enable(tmrSleep); 
  }  else {
    if (debug) {Serial.printf("\r\nCould not find specified switch!");}
  }
  
      
  /*
  if (kasaSwitch != NULL)
  {
    Serial.printf("\r\nTurn On the plug");
    kasaSwitch->SetRelayState(!plugstatus);  //go to next state on or off
    //kasaSwitch->QueryInfo();
    //vTaskDelay(2000 / portTICK_PERIOD_MS);
    //Serial.printf("\r\nTurn Off the plug");
    //kasaSwitch->SetRelayState(0);
    //kasaSwitch->QueryInfo();
  }
  */
  
}

void goToSleep()
{
  
  //if (debug) {Serial.println("Going to sleep...");}
  //delay(100);

  //Per: https://forum.seeedstudio.com/t/external-wakeup-from-deep-sleep-on-xiao-esp32c/267532/5
  //esp_deep_sleep_enable_gpio_wakeup(1ULL << 3,ESP_GPIO_WAKEUP_GPIO_HIGH); 
  //https://randomnerdtutorials.com/esp32-deep-sleep-arduino-ide-wake-up-sources/
  
  //Use for the SEEED XIAO
  esp_deep_sleep_enable_gpio_wakeup(1ULL << 3,ESP_GPIO_WAKEUP_GPIO_HIGH);   //Using Button on Pin D1
  //esp_deep_sleep_enable_gpio_wakeup(D1,ESP_GPIO_WAKEUP_GPIO_HIGH);   
  digitalWrite(LEDPin, LOW);
  
  //For the M5Stack Atom Lite
  //esp_sleep_enable_ext0_wakeup((gpio_num_t)39, 0);

  if (debug) {Serial.println("going to sleep NOW.");}
  esp_deep_sleep_start();   


  //https://randomnerdtutorials.com/esp8266-deep-sleep-with-arduino-ide/
  //ESP.deepSleep(0); 
  //ESP.deepSleep(5e6);  //sleep for 5 seconds. 5 to the 6 microseconds
  //BE CAREFUL USING THIS as it causes reboots and hard to upload after
  //esp_sleep_enable_timer_wakeup(TIME_TO_SLEEP * uS_TO_S_FACTOR);
  //The following command is intended to turn off all RTC peripherals in deep sleep.
  //esp_sleep_pd_config(ESP_PD_DOMAIN_RTC_PERIPH, ESP_PD_OPTION_OFF);
  //esp_deep_sleep_start();
 
}

void scanDevices()
{
  int found;
  found = kasaUtil.ScanDevices();
  if (debug) {Serial.printf("\r\n Found device = %d", found);}

  // Print out devices name and ip address found..
  for (int i = 0; i < found; i++)
  {
    KASASmartPlug *p = kasaUtil.GetSmartPlugByIndex(i);
    
    if (debug) {
      if (p != NULL){Serial.printf("\r\n %d. %s IP: %s Relay: %d", i, p->alias, p->ip_address, p->state);}
    }
  }
}


void testReadButton()
{
  buttonState = digitalRead(buttonPin);
  // check if the pushbutton is pressed. If it is, the buttonState is HIGH:
  if (buttonState == HIGH) {
    // Button pulled high
    if (debug) {Serial.println("BTN PUSH:");}
    delay(1000);
  } else {
    // Button pulled low
    if (debug) {Serial.println("BTN NOT PUSHED:");}
    delay(1000);
  }

}

