
/*
 Board: TTGO (Lilygo) T-DISPLAY S3 ESP32 Dev board  (platformio.ini:  board = esp32dev)
if it faults to upload with USB device not detected, remove USB, push and hold the bottom left button, insert USB. Upload.

CREDIT TO TO https://github.com/billism1/esp32-cheap-yellow-display-examples/commits?author=billism1
https://github.com/billism1/esp32-cheap-yellow-display-examples/blob/main/projects/sand/main.cpp

References:

Touch function:  https://github.com/VolosR/TDisplayTouch/tree/main/touchT-display/touchMinimal
LilyGo Library (can get touch files here):  https://github.com/Xinyuan-LilyGO/T-Display-S3
Other Libraries for ideas:
https://github.com/adafruit/Adafruit_PixelDust/blob/master/examples/charliewing/charliewing.ino
https://github.com/adafruit/Adafruit_Arcada/blob/master/examples/pixeldust_demos/pixeldust_snow/pixeldust_snow.ino

*/

#include <Arduino.h>
#include <Arduino_GFX_Library.h>
#include <Wire.h>
//#include <Adafruit_Sensor.h>
//#include <Adafruit_ADXL345_U.h>
#define TOUCH_MODULES_CST_SELF

#include <unordered_map>
#include <unordered_set>
#include <math.h>
#include <pixelSand.h>
#include <TouchLib.h>



#define PIN_IIC_SCL                  17
#define PIN_IIC_SDA                  18

#define PIN_TOUCH_INT                16
#define PIN_TOUCH_RES                21

#define XPT2046_IRQ                  36
#define XPT2046_MOSI                 32
#define XPT2046_MISO                 39
#define XPT2046_CLK                  25
#define XPT2046_CS                   33


#define GFX_DEV_DEVICE LILYGO_T_DISPLAY_S3
#define GFX_EXTRA_PRE_INIT()              \
    {                                     \
        pinMode(15 /* PWD */, OUTPUT);    \
        digitalWrite(15 /* PWD */, HIGH); \
    }
#define GFX_BL 38
Arduino_DataBus *bus = new Arduino_ESP32PAR8Q(
    7 /* DC */, 6 /* CS */, 8 /* WR */, 9 /* RD */,
    39 /* D0 */, 40 /* D1 */, 41 /* D2 */, 42 /* D3 */, 45 /* D4 */, 46 /* D5 */, 47 /* D6 */, 48 /* D7 */);
Arduino_GFX *gfx = new Arduino_ST7789(bus, 5 /* RST */, 0 /* rotation */, true /* IPS */, 170 /* width */, 320 /* height */, 35 /* col offset 1 */, 0 /* row offset 1 */, 35 /* col offset 2 */, 0 /* row offset 2 */);
/*******************************************************************************
 * End of Arduino_GFX setting
 ******************************************************************************/


//int midx=120, midY=62;

/* Assign a unique ID to this sensor at the same time */
//Adafruit_ADXL345_Unified accel = Adafruit_ADXL345_Unified(12345);

TouchLib touch(Wire, PIN_IIC_SDA, PIN_IIC_SCL, CTS820_SLAVE_ADDRESS, PIN_TOUCH_RES);

// For PixelSand:  Convert scaled pixel to native pixel area and then draw it. see PixelSand.h for all functions
void drawScaledPixel(int16_t x, int16_t y, uint16_t color)
{
  // Scale
  int16_t scaledXCol = x * PIXEL_WIDTH;
  int16_t scaledYRow = y * PIXEL_WIDTH;

  for (uint16_t i = 0; i < PIXEL_WIDTH; i++)
  {
    for (uint16_t j = 0; j < PIXEL_WIDTH; j++)
    {
      gfx->drawPixel(scaledXCol + i, scaledYRow + j, color);
      //gfx->flush();
    }
  }
}


void displayRange(void);
void displayDataRate(void);
void displaySensorDetails(void);
float mapfloat(float x, float in_min, float in_max, float out_min, float out_max);



//################################################################################################
void setup(void)
{
  pinMode(PIN_TOUCH_RES, OUTPUT);
  digitalWrite(PIN_TOUCH_RES, LOW);
  delay(500);
  digitalWrite(PIN_TOUCH_RES, HIGH);


  Serial.begin(115200);

  Wire.begin(PIN_IIC_SDA, PIN_IIC_SCL);  //touch

   
  #ifdef GFX_EXTRA_PRE_INIT
    GFX_EXTRA_PRE_INIT();
  #endif


  gfx->begin();
  gfx->setRotation(1);
  gfx->fillScreen(BLACK);
  gfx->setTextSize(2);

  #ifdef GFX_BL
    pinMode(GFX_BL, OUTPUT);
    digitalWrite(GFX_BL, HIGH);
  #endif


 
  //Serial.println("Accelerometer Test"); Serial.println("");
  
  /* Initialise the sensor */
  //if(!accel.begin())
  //{
    /* There was a problem detecting the ADXL345 ... check your connections */
  //  Serial.println("Ooops, no ADXL345 detected ... Check your wiring!");
    //while(1);
  //}

  /* Set the range to whatever is appropriate for your project */
  //accel.setRange(ADXL345_RANGE_16_G);
  // accel.setRange(ADXL345_RANGE_8_G);
  // accel.setRange(ADXL345_RANGE_4_G);
  // accel.setRange(ADXL345_RANGE_2_G);
  
  /* Display some basic information on this sensor */
  //displaySensorDetails();
  
  /* Display additional settings (outside the scope of sensor_t) */
  //displayDataRate();
  //displayRange();
  //Serial.println("");

  colorChangeTime = millis() + 1000;  //PixelSand

  // Set the tallest pixel column to be 1 slot bellow the "bottom" (0,0 coordinate being top left.)
  for (int16_t xCol = 0; xCol < SCALED_COLS; xCol++)
    landedPixelsColumnTops[xCol] = SCALED_ROWS;

  //auto viewportWidth = gfx->width();
  //auto viewportHeight = gfx->height();

  //Serial.printf("Viewport dimensions (W x H): %i x %i\n", viewportWidth, viewportHeight);

  //delay(500);


}
//################################################################################################

void loop()
{
    //gfx->setCursor(random(gfx->width()), random(gfx->height()));
    //gfx->setTextColor(random(0xffff), random(0xffff));
    //gfx->setTextSize(random(6) /* x scale */, random(6) /* y scale */, random(2) /* pixel_margin */);
    //gfx->println("Hello World!");

    //delay(1000); // 1 second
    //gfx->fillScreen(BLACK);
      /* Get a new sensor event */ 
  //sensors_event_t event; 
  //accel.getEvent(&event);

  //Serial.println("xxxx");
 
  /* Display the results (acceleration is measured in m/s^2) */
  //Serial.print("X: "); Serial.print(event.acceleration.x); Serial.print("  ");
  //Serial.print("Y: "); Serial.print(event.acceleration.y); Serial.print("  ");
  //Serial.print("Z: "); Serial.print(event.acceleration.z); Serial.print("  ");Serial.println("m/s^2 ");
  //delay(100);


  //240 x 135
  //float oldX, oldY, oldZ;
  //int midx=120, midY=62;
  
  //gfx->fillCircle(120, 62, 10, BLUE);
  
  // int x = mapfloat(event.acceleration.x, -16.0, 16.0, 10, 230);
  // int y = mapfloat(event.acceleration.y, -16.0, 16.0, 10, 125);
  // int size = mapfloat(event.acceleration.z, -16.0, 16.0, 10, 30);

  //unsigned long currentMillis = millis();
  // Throttle FPS
  //unsigned long diffMillis = currentMillis - lastMillis;
  //if ((1000 / maxFps) > diffMillis)
  //{
  //  return;
  //}

  // Get frame rate.
  //fps = 1000 / max(currentMillis - lastMillis, 1UL);
  //sprintf(fpsStringBuffer, "fps:%4lu", fps);

  // Display frame rate
  //gfx->setTextColor(WHITE, BLACK);
  //gfx->setCursor(10,10);
  //gfx->print(fpsStringBuffer);
  //lastMillis = currentMillis;

  // Handle touch.
    if (touch.read()) 
    {
      TP_Point t = touch.getPoint(0);
      inputX = map(t.y, TS_MINX, TS_MAXX, 0, SCALED_COLS);
      inputY = map(t.x, TS_MINY, TS_MAXY, 0, SCALED_ROWS);
      //TESTING
      //gfx->setTextColor(YELLOW, BLACK);gfx->setCursor(200,10);gfx->print(t.x);gfx->print("  ");gfx->print(t.y);gfx->setTextColor(BLACK, BLACK);gfx->print(t.x);gfx->print("  ");gfx->print(t.y);
      //gfx->setTextColor(YELLOW, BLACK); gfx->setCursor(200,40);gfx->print(inputX);gfx->print("  ");gfx->print(inputY); gfx->setTextColor(BLACK, BLACK);  gfx->print(inputX);gfx->print("  ");gfx->print(inputY);
    }
    else
    {
      inputX = -1;
      inputY = -1;
    }
    doPixelSand(0);  //0 doesn't build the "hill". 1 builds a "hill"
}


//#################################################################################################

float mapfloat(float x, float in_min, float in_max, float out_min, float out_max)
{
  return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}

/*
void displaySensorDetails(void)
{
  sensor_t sensor;
  accel.getSensor(&sensor);
  Serial.println("------------------------------------");
  Serial.print  ("Sensor:       "); Serial.println(sensor.name);
  Serial.print  ("Driver Ver:   "); Serial.println(sensor.version);
  Serial.print  ("Unique ID:    "); Serial.println(sensor.sensor_id);
  Serial.print  ("Max Value:    "); Serial.print(sensor.max_value); Serial.println(" m/s^2");
  Serial.print  ("Min Value:    "); Serial.print(sensor.min_value); Serial.println(" m/s^2");
  Serial.print  ("Resolution:   "); Serial.print(sensor.resolution); Serial.println(" m/s^2");  
  Serial.println("------------------------------------");
  Serial.println("");
  delay(500);
}

void displayDataRate(void)
{
  Serial.print  ("Data Rate:    "); 
  
  switch(accel.getDataRate())
  {
    case ADXL345_DATARATE_3200_HZ:
      Serial.print  ("3200 "); 
      break;
    case ADXL345_DATARATE_1600_HZ:
      Serial.print  ("1600 "); 
      break;
    case ADXL345_DATARATE_800_HZ:
      Serial.print  ("800 "); 
      break;
    case ADXL345_DATARATE_400_HZ:
      Serial.print  ("400 "); 
      break;
    case ADXL345_DATARATE_200_HZ:
      Serial.print  ("200 "); 
      break;
    case ADXL345_DATARATE_100_HZ:
      Serial.print  ("100 "); 
      break;
    case ADXL345_DATARATE_50_HZ:
      Serial.print  ("50 "); 
      break;
    case ADXL345_DATARATE_25_HZ:
      Serial.print  ("25 "); 
      break;
    case ADXL345_DATARATE_12_5_HZ:
      Serial.print  ("12.5 "); 
      break;
    case ADXL345_DATARATE_6_25HZ:
      Serial.print  ("6.25 "); 
      break;
    case ADXL345_DATARATE_3_13_HZ:
      Serial.print  ("3.13 "); 
      break;
    case ADXL345_DATARATE_1_56_HZ:
      Serial.print  ("1.56 "); 
      break;
    case ADXL345_DATARATE_0_78_HZ:
      Serial.print  ("0.78 "); 
      break;
    case ADXL345_DATARATE_0_39_HZ:
      Serial.print  ("0.39 "); 
      break;
    case ADXL345_DATARATE_0_20_HZ:
      Serial.print  ("0.20 "); 
      break;
    case ADXL345_DATARATE_0_10_HZ:
      Serial.print  ("0.10 "); 
      break;
    default:
      Serial.print  ("???? "); 
      break;
  }  
  Serial.println(" Hz");  
}

void displayRange(void)
{
  Serial.print  ("Range:         +/- "); 
  
  switch(accel.getRange())
  {
    case ADXL345_RANGE_16_G:
      Serial.print  ("16 "); 
      break;
    case ADXL345_RANGE_8_G:
      Serial.print  ("8 "); 
      break;
    case ADXL345_RANGE_4_G:
      Serial.print  ("4 "); 
      break;
    case ADXL345_RANGE_2_G:
      Serial.print  ("2 "); 
      break;
    default:
      Serial.print  ("?? "); 
      break;
  }  
  Serial.println(" g");  
}
*/